/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization;

import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import java.util.function.Predicate;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum ETestSelectionReason {
    COVERS_CHANGES("Impacted", "blue"),
    COVERS_DELETED("Impacted", "blue"),
    ADDED_OR_MODIFIED_TEST("New or changed", "orange"),
    PREVIOUSLY_FAILED("Failed", "red"),
    PREVIOUSLY_SKIPPED("Skipped", "grey"),
    COVERS_OTHER("Not impacted", "grey");

    public final String readableName;
    public final String cssColorClass;

    private ETestSelectionReason(String readableName, String cssColorClass) {
        this.readableName = readableName;
        this.cssColorClass = cssColorClass;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public static Predicate<IPrioritizableTests> containsAnyFilter(ETestSelectionReason testSelectionReason) {
        return test -> test.getSelectionReasons().stream().anyMatch(testSelectionReason::equals);
    }
}

