/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ITeamscaleIssueFindingLocation;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=TeamscaleIssueLocation.class)
@IndexValueClass(containedInBackup=true)
public class TeamscaleIssueLocation
extends ElementLocation
implements ITeamscaleIssueFindingLocation {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="issueId")
    private final String issueId;

    public TeamscaleIssueLocation(TeamscaleIssueLocation location) {
        super(location.getUniformPath());
        this.issueId = location.issueId;
    }

    public TeamscaleIssueLocation(String uniformPath, String issueId) {
        super(uniformPath);
        this.issueId = issueId;
    }

    @Override
    public String getLocationKey() {
        return this.toLocationString() + " (issue: " + this.issueId + ")";
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TeamscaleIssueLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TeamscaleIssueLocation)) {
            return false;
        }
        TeamscaleIssueLocation that = (TeamscaleIssueLocation)o;
        return that.canEqual(this) && Objects.equals(this.issueId, that.issueId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.issueId);
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }
}

