/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.Contract;

@IndexValueClass
public class MergeRequestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = '/';
    @JsonProperty(value="repositoryName")
    public final String repositoryName;
    @JsonProperty(value="id")
    public final long id;

    @JsonCreator
    public MergeRequestIdentifier(@JsonProperty(value="repositoryName") String repositoryName, @JsonProperty(value="id") long id) {
        this.repositoryName = repositoryName;
        this.id = id;
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable MergeRequestIdentifier fromString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Pair parts = StringUtils.splitAtLast((String)value, (char)'/');
        Preconditions.checkNotNull((Object)((String)parts.getSecond()), (String)"Merge request identifier has wrong format: %s", (Object)value);
        return new MergeRequestIdentifier((String)parts.getFirst(), Long.parseLong((String)parts.getSecond()));
    }

    @JsonProperty(value="idWithRepository")
    public String toString() {
        return this.repositoryName + "/" + this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MergeRequestIdentifier identifier = (MergeRequestIdentifier)other;
        return this.id == identifier.id && this.repositoryName.equalsIgnoreCase(identifier.repositoryName);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryName, this.id);
    }
}

