/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.analysis.sonarapi.MultivalueProperty;
import org.sonarsource.sonarlint.core.clientapi.backend.analysis.AnalysisService;
import org.sonarsource.sonarlint.core.clientapi.backend.analysis.GetSupportedFilePatternsParams;
import org.sonarsource.sonarlint.core.clientapi.backend.analysis.GetSupportedFilePatternsResponse;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.storage.StorageService;

@Named
@Singleton
public class AnalysisServiceImpl
implements AnalysisService {
    private final ConfigurationRepository configurationRepository;
    private final LanguageSupportRepository languageSupportRepository;
    private final StorageService storageService;

    public AnalysisServiceImpl(ConfigurationRepository configurationRepository, LanguageSupportRepository languageSupportRepository, StorageService storageService) {
        this.configurationRepository = configurationRepository;
        this.languageSupportRepository = languageSupportRepository;
        this.storageService = storageService;
    }

    @Override
    public CompletableFuture<GetSupportedFilePatternsResponse> getSupportedFilePatterns(GetSupportedFilePatternsParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Map<String, String> analysisSettings;
            Set<Language> enabledLanguages;
            String configScopeId = params.getConfigScopeId();
            Optional<Binding> effectiveBinding = this.configurationRepository.getEffectiveBinding(configScopeId);
            if (effectiveBinding.isEmpty()) {
                enabledLanguages = this.languageSupportRepository.getEnabledLanguagesInStandaloneMode();
                analysisSettings = Collections.emptyMap();
            } else {
                enabledLanguages = this.languageSupportRepository.getEnabledLanguagesInConnectedMode();
                analysisSettings = this.storageService.binding(effectiveBinding.get()).analyzerConfiguration().read().getSettings().getAll();
            }
            List<String> patterns = AnalysisServiceImpl.getPatterns(enabledLanguages, analysisSettings);
            return new GetSupportedFilePatternsResponse(patterns);
        });
    }

    @NotNull
    private static List<String> getPatterns(Set<Language> enabledLanguages, Map<String, String> analysisSettings) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Language language : enabledLanguages) {
            String propertyValue = analysisSettings.get(language.getFileSuffixesPropKey());
            String[] extensions = propertyValue == null ? language.getDefaultFileSuffixes() : MultivalueProperty.parseAsCsv(language.getFileSuffixesPropKey(), propertyValue);
            for (String suffix : extensions) {
                String sanitizedExtension = LanguageDetection.sanitizeExtension(suffix);
                patterns.add("**/*." + sanitizedExtension);
            }
        }
        return patterns;
    }
}

