/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.api.utils.WildcardPattern;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.sonarapi.DefaultFilterableIssue;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class IgnoreIssuesFilter
implements IssueFilter {
    private final Map<InputComponent, List<WildcardPattern>> rulePatternByComponent = new HashMap<InputComponent, List<WildcardPattern>>();
    private static final SonarLintLogger LOG = SonarLintLogger.get();

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
        if (component.isFile() && ((SonarLintInputFile)component).isIgnoreAllIssues() || component.isFile() && ((SonarLintInputFile)component).isIgnoreAllIssuesOnLine(issue.line())) {
            return false;
        }
        if (this.hasRuleMatchFor(component, issue)) {
            return false;
        }
        return chain.accept(issue);
    }

    public void addRuleExclusionPatternForComponent(SonarLintInputFile inputFile, WildcardPattern rulePattern) {
        if ("*".equals(rulePattern.toString())) {
            inputFile.setIgnoreAllIssues(true);
        } else {
            this.rulePatternByComponent.computeIfAbsent(inputFile, x -> new LinkedList()).add(rulePattern);
        }
    }

    private boolean hasRuleMatchFor(InputComponent component, FilterableIssue issue) {
        for (WildcardPattern pattern : this.rulePatternByComponent.getOrDefault(component, Collections.emptyList())) {
            if (!pattern.match(issue.ruleKey().toString())) continue;
            LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, (Object)pattern);
            return true;
        }
        return false;
    }
}

