/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.module;

import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.container.ContainerLifespan;
import org.sonarsource.sonarlint.core.analysis.container.analysis.AnalysisContainer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.IssueListenerHolder;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.analysis.container.global.AnalysisExtensionInstaller;
import org.sonarsource.sonarlint.core.analysis.container.module.ModuleFileEventNotifier;
import org.sonarsource.sonarlint.core.analysis.container.module.ModuleInputFileBuilder;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ActiveRuleAdapter;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ActiveRulesAdapter;
import org.sonarsource.sonarlint.core.analysis.sonarapi.SonarLintModuleFileSystem;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.container.SpringComponentContainer;

public class ModuleContainer
extends SpringComponentContainer {
    private final boolean isTransient;

    public ModuleContainer(SpringComponentContainer parent, boolean isTransient) {
        super(parent);
        this.isTransient = isTransient;
    }

    @Override
    protected void doBeforeStart() {
        this.add(SonarLintModuleFileSystem.class, ModuleInputFileBuilder.class, FileMetadata.class, LanguageDetection.class, ModuleFileEventNotifier.class);
        this.getParent().getComponentByType(AnalysisExtensionInstaller.class).install(this, ContainerLifespan.MODULE);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public AnalysisResults analyze(AnalysisConfiguration configuration, Consumer<Issue> issueListener, ProgressMonitor progress) {
        AnalysisContainer analysisContainer = new AnalysisContainer((SpringComponentContainer)this, progress);
        analysisContainer.add(configuration);
        analysisContainer.add(new IssueListenerHolder(issueListener));
        analysisContainer.add(new ActiveRulesAdapter(configuration.activeRules().stream().map(ActiveRuleAdapter::new).collect(Collectors.toList())));
        AnalysisResults defaultAnalysisResult = new AnalysisResults();
        analysisContainer.add(defaultAnalysisResult);
        analysisContainer.execute();
        return defaultAnalysisResult;
    }
}

