/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import com.google.common.util.concurrent.MoreExecutors;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.concurrent.ThreadFactories;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class WebSocketClient {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    @Nullable
    private final String token;
    private final ExecutorService executor;
    private final HttpClient httpClient;

    WebSocketClient(@Nullable String token) {
        this.token = token;
        this.executor = Executors.newCachedThreadPool(ThreadFactories.threadWithNamePrefix("sonarcloud-websocket-"));
        this.httpClient = HttpClient.newBuilder().executor(this.executor).build();
    }

    public WebSocket createWebSocketConnection(String url, Consumer<String> messageConsumer, Runnable onClosedRunnable) {
        return this.httpClient.newWebSocketBuilder().header("Authorization", "Bearer " + this.token).buildAsync(URI.create(url), new MessageConsummerWrapper(messageConsumer, onClosedRunnable)).join();
    }

    private class MessageConsummerWrapper
    implements WebSocket.Listener {
        private final Consumer<String> messageConsumer;
        private final Runnable onClosedRunnable;

        public MessageConsummerWrapper(Consumer<String> messageConsumer, Runnable onClosedRunnable) {
            this.messageConsumer = messageConsumer;
            this.onClosedRunnable = onClosedRunnable;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            LOG.debug("WebSocket opened");
            WebSocket.Listener.super.onOpen(webSocket);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.messageConsumer.accept(data.toString());
            return WebSocket.Listener.super.onText(webSocket, data, last);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            LOG.error("Error occurred on the WebSocket", error);
            this.finalizeWebSocket();
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            LOG.debug("WebSocket closed, status=" + statusCode + ", reason=" + reason);
            try {
                webSocket.sendClose(1000, "").get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return new CompletableFuture();
            }
            catch (ExecutionException e) {
                LOG.debug("Cannot ack WebSocket close");
            }
            this.finalizeWebSocket();
            return new CompletableFuture();
        }

        private void finalizeWebSocket() {
            try {
                this.onClosedRunnable.run();
            }
            finally {
                if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)WebSocketClient.this.executor, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
                    LOG.warn("Unable to stop web socket executor service in a timely manner");
                }
            }
        }
    }
}

