/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.api.Plugin;
import org.sonar.api.utils.System2;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.plugin.commons.DataflowBugDetection;
import org.sonarsource.sonarlint.core.plugin.commons.LoadedPlugins;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginInstancesLoader;
import org.sonarsource.sonarlint.core.plugin.commons.loading.PluginRequirementsCheckResult;
import org.sonarsource.sonarlint.core.plugin.commons.loading.SonarPluginRequirementsChecker;

public class PluginsLoader {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SonarPluginRequirementsChecker requirementsChecker = new SonarPluginRequirementsChecker();

    public PluginsLoadResult load(Configuration configuration) {
        String javaSpecVersion = Objects.requireNonNull(System2.INSTANCE.property("java.specification.version"), "Missing Java property 'java.specification.version'");
        Map<String, PluginRequirementsCheckResult> pluginCheckResultByKeys = this.requirementsChecker.checkRequirements(configuration.pluginJarLocations, configuration.enabledLanguages, Version.create(javaSpecVersion), configuration.shouldCheckNodeVersion, configuration.nodeCurrentVersion, configuration.enableDataflowBugDetection);
        Collection<PluginInfo> nonSkippedPlugins = PluginsLoader.getNonSkippedPlugins(pluginCheckResultByKeys);
        PluginsLoader.logPlugins(nonSkippedPlugins);
        PluginInstancesLoader instancesLoader = new PluginInstancesLoader();
        Map<String, Plugin> pluginInstancesByKeys = instancesLoader.instantiatePluginClasses(nonSkippedPlugins);
        return new PluginsLoadResult(new LoadedPlugins(pluginInstancesByKeys, instancesLoader, PluginsLoader.additionalAllowedPlugins(configuration)), pluginCheckResultByKeys);
    }

    private static Set<String> additionalAllowedPlugins(Configuration configuration) {
        HashSet<String> allowedPluginsIds = new HashSet<String>();
        allowedPluginsIds.add("textenterprise");
        allowedPluginsIds.addAll(PluginsLoader.maybeDbdAllowedPlugins(configuration.enableDataflowBugDetection));
        return Collections.unmodifiableSet(allowedPluginsIds);
    }

    private static Set<String> maybeDbdAllowedPlugins(boolean enableDataflowBugDetection) {
        return DataflowBugDetection.getPluginAllowList(enableDataflowBugDetection);
    }

    private static void logPlugins(Collection<PluginInfo> nonSkippedPlugins) {
        LOG.debug("Loaded {} plugins", (Object)nonSkippedPlugins.size());
        for (PluginInfo p : nonSkippedPlugins) {
            LOG.debug("  * {} {} ({})", p.getName(), p.getVersion(), p.getKey());
        }
    }

    private static Collection<PluginInfo> getNonSkippedPlugins(Map<String, PluginRequirementsCheckResult> pluginCheckResultByKeys) {
        return pluginCheckResultByKeys.values().stream().filter(Predicate.not(PluginRequirementsCheckResult::isSkipped)).map(PluginRequirementsCheckResult::getPlugin).collect(Collectors.toList());
    }

    public static class Configuration {
        private final Set<Path> pluginJarLocations;
        private final Set<Language> enabledLanguages;
        private final boolean shouldCheckNodeVersion;
        private final Optional<Version> nodeCurrentVersion;
        private final boolean enableDataflowBugDetection;

        public Configuration(Set<Path> pluginJarLocations, Set<Language> enabledLanguages, boolean enableDataflowBugDetection) {
            this.pluginJarLocations = pluginJarLocations;
            this.enabledLanguages = enabledLanguages;
            this.nodeCurrentVersion = Optional.empty();
            this.enableDataflowBugDetection = enableDataflowBugDetection;
            this.shouldCheckNodeVersion = false;
        }

        public Configuration(Set<Path> pluginJarLocations, Set<Language> enabledLanguages, boolean enableDataflowBugDetection, Optional<Version> nodeCurrentVersion) {
            this.pluginJarLocations = pluginJarLocations;
            this.enabledLanguages = enabledLanguages;
            this.nodeCurrentVersion = nodeCurrentVersion;
            this.enableDataflowBugDetection = enableDataflowBugDetection;
            this.shouldCheckNodeVersion = true;
        }
    }
}

