/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class SecurityHotspotClosedEventParser
implements EventParser<SecurityHotspotClosedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<SecurityHotspotClosedEvent> parse(String jsonData) {
        HotspotClosedEventPayload payload = this.gson.fromJson(jsonData, HotspotClosedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'SecurityHotspotClosed' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new SecurityHotspotClosedEvent(payload.projectKey, payload.key, payload.filePath));
    }

    private static class HotspotClosedEventPayload {
        private String projectKey;
        private String key;
        private String filePath;

        private HotspotClosedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.projectKey) || ServerApiUtils.isBlank(this.key) || ServerApiUtils.isBlank(this.filePath);
        }
    }
}

