/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.RuleSet;
import org.sonarsource.sonarlint.core.serverconnection.Settings;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageException;

public class AnalyzerConfigurationStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final RWLock rwLock = new RWLock();
    private final Path storageFilePath;

    public AnalyzerConfigurationStorage(Path projectStorageRoot) {
        this.storageFilePath = projectStorageRoot.resolve("analyzer_config.pb");
    }

    public void store(AnalyzerConfiguration analyzerConfiguration) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        Sonarlint.AnalyzerConfiguration data = AnalyzerConfigurationStorage.adapt(analyzerConfiguration);
        LOG.debug("Storing project analyzer configuration in {}", (Object)this.storageFilePath);
        this.rwLock.write(() -> ProtobufFileUtil.writeToFile(data, this.storageFilePath));
    }

    public AnalyzerConfiguration read() {
        return AnalyzerConfigurationStorage.adapt(this.rwLock.read(() -> AnalyzerConfigurationStorage.readConfiguration(this.storageFilePath)));
    }

    public void update(UnaryOperator<AnalyzerConfiguration> updater) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        this.rwLock.write(() -> {
            Sonarlint.AnalyzerConfiguration config;
            try {
                config = AnalyzerConfigurationStorage.readConfiguration(this.storageFilePath);
            }
            catch (StorageException e) {
                LOG.warn("Unable to read storage. Creating a new one.", e);
                config = Sonarlint.AnalyzerConfiguration.newBuilder().build();
            }
            ProtobufFileUtil.writeToFile(AnalyzerConfigurationStorage.adapt((AnalyzerConfiguration)updater.apply(AnalyzerConfigurationStorage.adapt(config))), this.storageFilePath);
            LOG.debug("Storing project data in {}", (Object)this.storageFilePath);
        });
    }

    private static Sonarlint.AnalyzerConfiguration readConfiguration(Path projectFilePath) {
        return ProtobufFileUtil.readFile(projectFilePath, Sonarlint.AnalyzerConfiguration.parser());
    }

    private static AnalyzerConfiguration adapt(Sonarlint.AnalyzerConfiguration analyzerConfiguration) {
        return new AnalyzerConfiguration(new Settings(analyzerConfiguration.getSettingsMap()), analyzerConfiguration.getRuleSetsByLanguageKeyMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AnalyzerConfigurationStorage.adapt((Sonarlint.RuleSet)e.getValue()))), analyzerConfiguration.getSchemaVersion());
    }

    private static Sonarlint.AnalyzerConfiguration adapt(AnalyzerConfiguration analyzerConfiguration) {
        return Sonarlint.AnalyzerConfiguration.newBuilder().setSchemaVersion(analyzerConfiguration.getSchemaVersion()).putAllSettings(analyzerConfiguration.getSettings().getAll()).putAllRuleSetsByLanguageKey(analyzerConfiguration.getRuleSetByLanguageKey().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AnalyzerConfigurationStorage.adapt((RuleSet)e.getValue())))).build();
    }

    private static RuleSet adapt(Sonarlint.RuleSet ruleSet) {
        return new RuleSet(ruleSet.getRuleList().stream().map(AnalyzerConfigurationStorage::adapt).collect(Collectors.toList()), ruleSet.getLastModified());
    }

    private static ServerActiveRule adapt(Sonarlint.RuleSet.ActiveRule rule) {
        return new ServerActiveRule(rule.getRuleKey(), IssueSeverity.valueOf(rule.getSeverity()), rule.getParamsMap(), rule.getTemplateKey());
    }

    private static Sonarlint.RuleSet adapt(RuleSet ruleSet) {
        return Sonarlint.RuleSet.newBuilder().setLastModified(ruleSet.getLastModified()).addAllRule(ruleSet.getRules().stream().map(AnalyzerConfigurationStorage::adapt).collect(Collectors.toList())).build();
    }

    private static Sonarlint.RuleSet.ActiveRule adapt(ServerActiveRule rule) {
        return Sonarlint.RuleSet.ActiveRule.newBuilder().setRuleKey(rule.getRuleKey()).setSeverity(rule.getSeverity().name()).setTemplateKey(rule.getTemplateKey()).putAllParams(rule.getParams()).build();
    }
}

