/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacade;

public class StorageFacadeCache {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final StorageFacadeCache uniqueFacade = new StorageFacadeCache();
    private final Map<Path, StorageFacade> facadePerRootPath = new ConcurrentHashMap<Path, StorageFacade>();

    public static StorageFacadeCache get() {
        return uniqueFacade;
    }

    public StorageFacade getOrCreate(Path globalStorageRoot, Path workDir) {
        return this.facadePerRootPath.computeIfAbsent(globalStorageRoot, k -> {
            LOG.debug("Creating a new StorageFacade for storageRoot={} and workDir={}", (Object)globalStorageRoot, (Object)workDir);
            return new StorageFacade(globalStorageRoot, workDir);
        });
    }

    public void close(Path globalStorageRoot) {
        StorageFacade removed = this.facadePerRootPath.remove(globalStorageRoot);
        if (removed != null) {
            removed.close();
        }
    }
}

