/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.plugins.ServerPlugin;
import org.sonarsource.sonarlint.core.serverconnection.StoredPlugin;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageException;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;

public class PluginsStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final String PLUGIN_REFERENCES_PB = "plugin_references.pb";
    private final Path rootPath;
    private final Path pluginReferencesFilePath;
    private final RWLock rwLock = new RWLock();

    public PluginsStorage(Path connectionStorageRoot) {
        this.rootPath = connectionStorageRoot.resolve("plugins");
        this.pluginReferencesFilePath = this.rootPath.resolve(PLUGIN_REFERENCES_PB);
    }

    public void store(ServerPlugin plugin, InputStream pluginBinary) {
        try {
            FileUtils.copyInputStreamToFile(pluginBinary, this.rootPath.resolve(plugin.getFilename()).toFile());
            Sonarlint.PluginReferences.PluginReference reference = PluginsStorage.adapt(plugin);
            this.rwLock.write(() -> {
                Sonarlint.PluginReferences references = Files.exists(this.pluginReferencesFilePath, new LinkOption[0]) ? ProtobufFileUtil.readFile(this.pluginReferencesFilePath, Sonarlint.PluginReferences.parser()) : Sonarlint.PluginReferences.newBuilder().build();
                Sonarlint.PluginReferences.Builder currentReferences = Sonarlint.PluginReferences.newBuilder(references);
                currentReferences.putPluginsByKey(plugin.getKey(), reference);
                ProtobufFileUtil.writeToFile(currentReferences.build(), this.pluginReferencesFilePath);
            });
        }
        catch (IOException e) {
            throw new StorageException("Cannot save plugin " + plugin.getFilename() + " in " + this.rootPath, e);
        }
    }

    public List<StoredPlugin> getStoredPlugins() {
        return this.rwLock.read(() -> Files.exists(this.pluginReferencesFilePath, new LinkOption[0]) ? ProtobufFileUtil.readFile(this.pluginReferencesFilePath, Sonarlint.PluginReferences.parser()) : Sonarlint.PluginReferences.newBuilder().build()).getPluginsByKeyMap().values().stream().map(this::adapt).collect(Collectors.toList());
    }

    public Map<String, StoredPlugin> getStoredPluginsByKey() {
        return PluginsStorage.byKey(this.getStoredPlugins());
    }

    public Map<String, Path> getStoredPluginPathsByKey() {
        return PluginsStorage.byKey(this.getStoredPlugins()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((StoredPlugin)v.getValue()).getJarPath()));
    }

    private static Map<String, StoredPlugin> byKey(List<StoredPlugin> plugins) {
        return plugins.stream().collect(Collectors.toMap(StoredPlugin::getKey, Function.identity()));
    }

    private static Sonarlint.PluginReferences.PluginReference adapt(ServerPlugin plugin) {
        return Sonarlint.PluginReferences.PluginReference.newBuilder().setKey(plugin.getKey()).setHash(plugin.getHash()).setFilename(plugin.getFilename()).build();
    }

    private StoredPlugin adapt(Sonarlint.PluginReferences.PluginReference plugin) {
        return new StoredPlugin(plugin.getKey(), plugin.getHash(), this.rootPath.resolve(plugin.getFilename()));
    }

    public void cleanUp() {
        this.getUnknownFiles().forEach(FileUtils::deleteQuietly);
    }

    private List<File> getUnknownFiles() {
        List<File> list;
        block9: {
            if (!Files.exists(this.rootPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Set knownPluginsPaths = this.getStoredPlugins().stream().map(StoredPlugin::getJarPath).collect(Collectors.toSet());
            Stream<Path> pathsInDir = Files.list(this.rootPath);
            try {
                list = pathsInDir.filter(p -> !p.equals(this.pluginReferencesFilePath)).filter(p -> !knownPluginsPaths.contains(p)).map(Path::toFile).collect(Collectors.toList());
                if (pathsInDir == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathsInDir != null) {
                        try {
                            pathsInDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Cannot list files in '{}'", (Object)this.rootPath, (Object)e);
                    return Collections.emptyList();
                }
            }
            pathsInDir.close();
        }
        return list;
    }
}

