/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.websocket;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.event.BindingConfigChangedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopeRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopesAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationAddedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationUpdatedEvent;
import org.sonarsource.sonarlint.core.event.ConnectionCredentialsChangedEvent;
import org.sonarsource.sonarlint.core.http.ConnectionAwareHttpClientProvider;
import org.sonarsource.sonarlint.core.repository.config.BindingConfiguration;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.push.IssueChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotRaisedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityClosedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityRaisedEvent;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.StorageFacade;
import org.sonarsource.sonarlint.core.serverconnection.events.EventDispatcher;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotChanged;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotClosed;
import org.sonarsource.sonarlint.core.serverconnection.events.hotspot.UpdateStorageOnSecurityHotspotRaised;
import org.sonarsource.sonarlint.core.serverconnection.events.issue.UpdateStorageOnIssueChanged;
import org.sonarsource.sonarlint.core.serverconnection.events.taint.UpdateStorageOnTaintVulnerabilityClosed;
import org.sonarsource.sonarlint.core.serverconnection.events.taint.UpdateStorageOnTaintVulnerabilityRaised;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.websocket.ShowSmartNotificationOnSmartNotificationEvent;
import org.sonarsource.sonarlint.core.websocket.SonarCloudWebSocket;
import org.sonarsource.sonarlint.core.websocket.events.SmartNotificationEvent;

public class WebSocketService {
    private final Map<String, String> subscribedProjectKeysByConfigScopes = new HashMap<String, String>();
    private final Set<String> connectionIdsInterestedInNotifications = new HashSet<String>();
    private final boolean shouldEnableWebSockets;
    private final ConnectionConfigurationRepository connectionConfigurationRepository;
    private final ConfigurationRepository configurationRepository;
    private final ConnectionAwareHttpClientProvider connectionAwareHttpClientProvider;
    private final Map<String, EventDispatcher> eventRouterByConnectionId;
    private final StorageFacade storageFacade;
    private final SonarLintClient client;
    private final TelemetryServiceImpl telemetryService;
    protected SonarCloudWebSocket sonarCloudWebSocket;
    private String connectionIdUsedToCreateConnection;

    public WebSocketService(SonarLintClient client, ConnectionConfigurationRepository connectionConfigurationRepository, ConfigurationRepository configurationRepository, ConnectionAwareHttpClientProvider connectionAwareHttpClientProvider, TelemetryServiceImpl telemetryService, StorageService storageService, InitializeParams params) {
        this.connectionConfigurationRepository = connectionConfigurationRepository;
        this.configurationRepository = configurationRepository;
        this.connectionAwareHttpClientProvider = connectionAwareHttpClientProvider;
        this.shouldEnableWebSockets = params.getFeatureFlags().shouldManageServerSentEvents();
        this.storageFacade = storageService.getStorageFacade();
        this.eventRouterByConnectionId = new HashMap<String, EventDispatcher>();
        this.client = client;
        this.telemetryService = telemetryService;
    }

    protected void reopenConnectionOnClose() {
        String connectionId = this.connectionIdsInterestedInNotifications.stream().findFirst().orElse(null);
        if (this.sonarCloudWebSocket != null && connectionId != null) {
            this.reopenConnection(connectionId);
        }
    }

    @Subscribe
    public void handleEvent(BindingConfigChangedEvent bindingConfigChangedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        this.considerScope(bindingConfigChangedEvent.getConfigScopeId());
    }

    @Subscribe
    public void handleEvent(ConfigurationScopesAddedEvent configurationScopesAddedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        this.considerAllBoundConfigurationScopes(configurationScopesAddedEvent.getAddedConfigurationScopeIds());
    }

    @Subscribe
    public void handleEvent(ConfigurationScopeRemovedEvent configurationScopeRemovedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        String removedConfigurationScopeId = configurationScopeRemovedEvent.getRemovedConfigurationScopeId();
        this.forget(removedConfigurationScopeId);
        this.closeSocketIfNoMoreNeeded();
    }

    @Subscribe
    public void handleEvent(ConnectionConfigurationAddedEvent connectionConfigurationAddedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        this.considerConnection(connectionConfigurationAddedEvent.getAddedConnectionId());
    }

    @Subscribe
    public void handleEvent(ConnectionConfigurationUpdatedEvent connectionConfigurationUpdatedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        String updatedConnectionId = connectionConfigurationUpdatedEvent.getUpdatedConnectionId();
        if (this.didDisableNotifications(updatedConnectionId)) {
            this.forgetConnection(updatedConnectionId);
        } else if (this.didEnableNotifications(updatedConnectionId)) {
            this.considerConnection(updatedConnectionId);
        }
    }

    @Subscribe
    public void handleEvent(ConnectionConfigurationRemovedEvent connectionConfigurationRemovedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        String removedConnectionId = connectionConfigurationRemovedEvent.getRemovedConnectionId();
        this.forgetConnection(removedConnectionId);
    }

    @Subscribe
    public void handleEvent(ConnectionCredentialsChangedEvent connectionCredentialsChangedEvent) {
        if (!this.shouldEnableWebSockets) {
            return;
        }
        String connectionId = connectionCredentialsChangedEvent.getConnectionId();
        if (this.isEligibleConnection(connectionId) && this.connectionIdsInterestedInNotifications.contains(connectionId)) {
            this.reopenConnection(connectionId);
        }
    }

    private boolean isEligibleConnection(String connectionId) {
        AbstractConnectionConfiguration connection = this.connectionConfigurationRepository.getConnectionById(connectionId);
        return connection != null && connection.getKind().equals((Object)ConnectionKind.SONARCLOUD) && !connection.isDisableNotifications();
    }

    private String getBoundProjectKey(String configScopeId) {
        BindingConfiguration bindingConfiguration = this.configurationRepository.getBindingConfiguration(configScopeId);
        if (bindingConfiguration != null && bindingConfiguration.isBound()) {
            return bindingConfiguration.getSonarProjectKey();
        }
        return null;
    }

    private Binding getCurrentBinding(String configScopeId) {
        BindingConfiguration bindingConfiguration = this.configurationRepository.getBindingConfiguration(configScopeId);
        if (bindingConfiguration != null && bindingConfiguration.isBound()) {
            return new Binding(Objects.requireNonNull(bindingConfiguration.getConnectionId()), Objects.requireNonNull(bindingConfiguration.getSonarProjectKey()));
        }
        return null;
    }

    private void closeSocketIfNoMoreNeeded() {
        if (this.subscribedProjectKeysByConfigScopes.isEmpty()) {
            this.closeSocket();
        }
    }

    private boolean didDisableNotifications(String connectionId) {
        if (this.connectionIdsInterestedInNotifications.contains(connectionId)) {
            AbstractConnectionConfiguration connection = this.connectionConfigurationRepository.getConnectionById(connectionId);
            return connection != null && connection.getKind().equals((Object)ConnectionKind.SONARCLOUD) && connection.isDisableNotifications();
        }
        return false;
    }

    private boolean didEnableNotifications(String connectionId) {
        return !this.connectionIdsInterestedInNotifications.contains(connectionId) && this.isEligibleConnection(connectionId);
    }

    private void considerConnection(String connectionId) {
        Set<String> configScopeIds = this.configurationRepository.getConfigScopesWithBindingConfiguredTo(connectionId).stream().map(ConfigurationScope::getId).collect(Collectors.toSet());
        this.considerAllBoundConfigurationScopes(configScopeIds);
    }

    private void forgetConnection(String connectionId) {
        this.eventRouterByConnectionId.remove(connectionId);
        boolean previouslyInterestedInNotifications = this.connectionIdsInterestedInNotifications.remove(connectionId);
        if (!previouslyInterestedInNotifications) {
            return;
        }
        if (this.connectionIdsInterestedInNotifications.isEmpty()) {
            this.closeSocket();
            this.subscribedProjectKeysByConfigScopes.clear();
        } else if (this.connectionIdUsedToCreateConnection.equals(connectionId)) {
            String otherConnectionId = (String)this.connectionIdsInterestedInNotifications.stream().findAny().orElseThrow();
            this.removeProjectsFromSubscriptionListForConnection(connectionId);
            this.reopenConnection(otherConnectionId);
        } else {
            this.configurationRepository.getConfigScopesWithBindingConfiguredTo(connectionId).forEach(configScope -> this.forget(configScope.getId()));
        }
    }

    private void reopenConnection(String connectionId) {
        this.closeSocket();
        this.createConnectionIfNeeded(connectionId);
        this.resubscribeAll();
    }

    private void considerAllBoundConfigurationScopes(Set<String> configScopeIds) {
        for (String scopeId : configScopeIds) {
            this.considerScope(scopeId);
        }
    }

    private void considerScope(String scopeId) {
        Binding binding = this.getCurrentBinding(scopeId);
        if (binding != null && this.isEligibleConnection(binding.getConnectionId())) {
            this.subscribe(scopeId, binding);
        } else if (this.isSubscribedWithProjectKeyDifferentThanCurrentBinding(scopeId)) {
            this.forget(scopeId);
            this.closeSocketIfNoMoreNeeded();
        }
    }

    private boolean isSubscribedWithProjectKeyDifferentThanCurrentBinding(String configScopeId) {
        String previousSubscribedProjectKeyForScope = this.subscribedProjectKeysByConfigScopes.get(configScopeId);
        return previousSubscribedProjectKeyForScope != null && !previousSubscribedProjectKeyForScope.equals(this.getBoundProjectKey(configScopeId));
    }

    private void removeProjectsFromSubscriptionListForConnection(String updatedConnectionId) {
        List<ConfigurationScope> configurationScopesToUnsubscribe = this.configurationRepository.getConfigScopesWithBindingConfiguredTo(updatedConnectionId);
        for (ConfigurationScope configScope : configurationScopesToUnsubscribe) {
            this.subscribedProjectKeysByConfigScopes.remove(configScope.getId());
        }
    }

    private void handleEventDispatcher(String connectionId) {
        ConnectionStorage storage = this.storageFacade.connection(connectionId);
        this.eventRouterByConnectionId.putIfAbsent(connectionId, new EventDispatcher().dispatch(SmartNotificationEvent.class, new ShowSmartNotificationOnSmartNotificationEvent(this.client, this.configurationRepository, this.telemetryService)).dispatch(IssueChangedEvent.class, new UpdateStorageOnIssueChanged(storage)).dispatch(SecurityHotspotClosedEvent.class, new UpdateStorageOnSecurityHotspotClosed(storage)).dispatch(SecurityHotspotRaisedEvent.class, new UpdateStorageOnSecurityHotspotRaised(storage)).dispatch(SecurityHotspotChangedEvent.class, new UpdateStorageOnSecurityHotspotChanged(storage)).dispatch(TaintVulnerabilityClosedEvent.class, new UpdateStorageOnTaintVulnerabilityClosed(storage)).dispatch(TaintVulnerabilityRaisedEvent.class, new UpdateStorageOnTaintVulnerabilityRaised(storage)));
    }

    private void subscribe(String configScopeId, Binding binding) {
        this.createConnectionIfNeeded(binding.getConnectionId());
        String projectKey = binding.getSonarProjectKey();
        if (this.subscribedProjectKeysByConfigScopes.containsKey(configScopeId) && !this.subscribedProjectKeysByConfigScopes.get(configScopeId).equals(projectKey)) {
            this.forget(configScopeId);
        }
        if (!this.subscribedProjectKeysByConfigScopes.containsValue(projectKey)) {
            this.sonarCloudWebSocket.subscribe(projectKey);
        }
        this.subscribedProjectKeysByConfigScopes.put(configScopeId, projectKey);
    }

    private void forget(String configScopeId) {
        String projectKey = this.subscribedProjectKeysByConfigScopes.remove(configScopeId);
        if (projectKey != null && !this.subscribedProjectKeysByConfigScopes.containsValue(projectKey) && this.sonarCloudWebSocket != null) {
            this.sonarCloudWebSocket.unsubscribe(projectKey);
        }
    }

    private void resubscribeAll() {
        this.subscribedProjectKeysByConfigScopes.forEach((configScope, projectKey) -> this.sonarCloudWebSocket.subscribe((String)projectKey));
    }

    private void createConnectionIfNeeded(String connectionId) {
        this.connectionIdsInterestedInNotifications.add(connectionId);
        this.handleEventDispatcher(connectionId);
        if (this.sonarCloudWebSocket == null) {
            this.sonarCloudWebSocket = SonarCloudWebSocket.create(this.connectionAwareHttpClientProvider.getWebSocketClient(connectionId), event -> {
                EventDispatcher eventRouter = this.eventRouterByConnectionId.get(connectionId);
                if (eventRouter != null) {
                    eventRouter.handle((ServerEvent)event);
                }
            }, this::reopenConnectionOnClose);
            this.connectionIdUsedToCreateConnection = connectionId;
        }
    }

    private void closeSocket() {
        if (this.sonarCloudWebSocket != null) {
            SonarCloudWebSocket socket = this.sonarCloudWebSocket;
            this.sonarCloudWebSocket = null;
            this.connectionIdUsedToCreateConnection = null;
            socket.close();
        }
    }

    public boolean hasOpenConnection() {
        return this.sonarCloudWebSocket != null && this.sonarCloudWebSocket.isOpen();
    }

    @PreDestroy
    public void shutdown() {
        this.connectionIdsInterestedInNotifications.clear();
        this.subscribedProjectKeysByConfigScopes.clear();
        this.closeSocket();
    }
}

