/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.websocket.parsing;

import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.core.websocket.events.SmartNotificationEvent;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class SmartNotificationEventParser
implements EventParser<SmartNotificationEvent> {
    private final Gson gson = new Gson();
    private final String category;

    public SmartNotificationEventParser(String category) {
        this.category = category;
    }

    @Override
    public Optional<SmartNotificationEvent> parse(String jsonData) {
        SmartNotificationEventPayload payload = this.gson.fromJson(jsonData, SmartNotificationEventPayload.class);
        if (payload.isInvalid()) {
            SonarLintLogger.get().error("Invalid payload for 'SmartNotification' event of category '" + this.category + "': {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new SmartNotificationEvent(payload.message, payload.link, payload.project, payload.date, this.category));
    }

    private static class SmartNotificationEventPayload {
        private String message;
        private String link;
        private String project;
        private String date;

        private SmartNotificationEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.message) || ServerApiUtils.isBlank(this.link) || ServerApiUtils.isBlank(this.project) || this.date == null;
        }
    }
}

