/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.teamscale.commons.annotation.ClassIndexUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexValidationUtils;
import org.conqat.engine.persistence.index.MetaIndex;

public class IndexCrawler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Collection<Class<? extends IGlobalIndex>> collectGlobalIndices() throws AssertionError {
        return IndexCrawler.collectIndices(IGlobalIndex.class);
    }

    private static <T extends IStorageIndex> Collection<Class<? extends T>> collectIndices(Class<T> indexTypeClass) {
        LOGGER.debug("Searching for indices");
        HashSet<Class<T>> collectedIndices = new HashSet<Class<T>>();
        List indexClasses = ClassIndexUtils.getAnnotated(Index.class);
        for (Class indexClass : indexClasses) {
            if (indexClass == MetaIndex.class) continue;
            IndexValidationUtils.validateIndexClass(indexClass);
            if (!indexTypeClass.isAssignableFrom(indexClass)) continue;
            collectedIndices.add(indexClass.asSubclass(indexTypeClass));
            LOGGER.debug("Collected index: " + String.valueOf(indexClass));
        }
        return collectedIndices;
    }
}

