/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.index.keyed.query.engine.AttributeCheckingDescriberCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.engine.AttributeCollectingDescriberCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.engine.CompilationContextBase;
import org.conqat.engine.persistence.index.keyed.query.engine.DescriberCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.parser.QueryParser;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.ISubQueryComputer;
import org.conqat.engine.persistence.index.keyed.query.trend.ITrendCollector;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

class QueryHelper<T> {
    private final IKeyedObjectIndex<T> index;
    private final List<String> attributeNames;
    private final PairList<String, String> exactValueColumns;
    private final Map<String, Integer> attributeIndex = new HashMap<String, Integer>();
    private final Map<String, EKeyedObjectType> validColumns;
    private final CompilationContextBase<TimedShallowObjectState> compilationContext;
    private final Predicate<TimedShallowObjectState> frozenObjectFilter;

    public QueryHelper(IKeyedObjectIndex<T> index, String query, Collection<IQueryPreprocessor> preprocessors, @Nullable ITrendCollector<?> trendCollector) throws QueryParsingException, QueryCompilationException, StorageException {
        int i;
        this.index = index;
        this.validColumns = new HashMap<String, EKeyedObjectType>(index.getKnownColumns().toMap());
        IQuery parsedQuery = QueryParser.parse(query, preprocessors);
        IKeyedObjectDescriber<T> describer = index.getDescriber();
        DescriberCompilationContext<T> describerCompilationContext = new DescriberCompilationContext<T>(describer);
        AttributeCollectingDescriberCompilationContext<T> context = new AttributeCollectingDescriberCompilationContext<T>(describerCompilationContext);
        parsedQuery.compile(new AttributeCheckingDescriberCompilationContext<T>(context, this.getValidColumnNames()));
        this.attributeNames = context.getMultiAccessedAttributes(this.validColumns);
        for (String column : index.getAlwaysQueryColumns()) {
            if (this.attributeNames.contains(column)) continue;
            this.attributeNames.add(column);
        }
        if (query.isEmpty()) {
            this.attributeNames.addAll(this.validColumns.keySet());
        }
        this.exactValueColumns = context.getExactValueAttributes(this.validColumns);
        if (trendCollector != null) {
            trendCollector.setRequiredAttributesStartIndex(this.attributeNames.size());
            this.attributeNames.addAll(trendCollector.getRequiredAttributes());
        }
        for (i = 0; i < this.attributeNames.size(); ++i) {
            this.attributeIndex.put(this.attributeNames.get(i), i);
        }
        for (i = 0; i < this.exactValueColumns.size(); ++i) {
            this.attributeIndex.put((String)this.exactValueColumns.getFirst(i), i + this.attributeNames.size());
        }
        this.compilationContext = new TimedShallowObjectStateCompilationContext(describerCompilationContext.getIdResolver());
        this.frozenObjectFilter = parsedQuery.compile(this.compilationContext);
    }

    private Set<String> getValidColumnNames() {
        HashSet<String> validColumnNames = new HashSet<String>(this.validColumns.keySet());
        validColumnNames.add("parent");
        return validColumnNames;
    }

    public void preEvaluateComputers(List<TimedShallowObjectState> objects, long queryTimestamp) {
        List<ISubQueryComputer<TimedShallowObjectState>> computers = this.getSubQueryComputers();
        ArrayList<Long> evaluationOffsets = new ArrayList<Long>(this.getPostChangeEvaluationOffsets());
        evaluationOffsets.add(0L);
        long firstEvaluatedTimestamp = Math.max(0L, queryTimestamp - Collections.max(evaluationOffsets));
        for (TimedShallowObjectState object : objects) {
            Set<Long> evalTimestamps = QueryHelper.calculateEvaluationTimestamps(queryTimestamp, firstEvaluatedTimestamp, evaluationOffsets, object);
            boolean wasAlwaysNullObject = true;
            Iterator iterator = CollectionUtils.sort(evalTimestamps).iterator();
            while (iterator.hasNext()) {
                long timestamp = (Long)iterator.next();
                object.freezeAt(timestamp);
                if (wasAlwaysNullObject && !object.hasNonNullFrozenValue()) continue;
                wasAlwaysNullObject = false;
                for (ISubQueryComputer<TimedShallowObjectState> computer : computers) {
                    computer.updateState(object, timestamp);
                }
            }
        }
    }

    private static Set<Long> calculateEvaluationTimestamps(long queryTimestamp, long firstEvaluatedTimestamp, List<Long> evaluationOffsets, TimedShallowObjectState object) {
        HashSet<Long> evalTimestamps = new HashSet<Long>();
        QueryHelper.addTimestampWithOffsets(firstEvaluatedTimestamp, evaluationOffsets, firstEvaluatedTimestamp, queryTimestamp, evalTimestamps);
        for (Long timestamp : object.getTimestamps()) {
            QueryHelper.addTimestampWithOffsets(timestamp, evaluationOffsets, firstEvaluatedTimestamp, queryTimestamp, evalTimestamps);
        }
        return evalTimestamps;
    }

    private static void addTimestampWithOffsets(long baseTimestamp, List<Long> offsets, long start, long end, Set<Long> result) {
        for (Long offset : offsets) {
            long evalTimestamp = baseTimestamp + offset;
            if (start > evalTimestamp || evalTimestamp > end) continue;
            result.add(evalTimestamp);
        }
    }

    List<ISubQueryComputer<TimedShallowObjectState>> getSubQueryComputers() {
        return this.compilationContext.getSubQueryComputers();
    }

    public Set<Long> getPostChangeEvaluationOffsets() {
        return this.compilationContext.getPostChangeEvaluationOffsets();
    }

    public List<TimedShallowObjectState> executeQuery(long timestamp) throws StorageException {
        return this.index.query(this.attributeNames, this.exactValueColumns, timestamp);
    }

    public Predicate<TimedShallowObjectState> getFrozenObjectFilter() {
        return object -> object.hasNonNullFrozenValue() && this.frozenObjectFilter.test((TimedShallowObjectState)object);
    }

    private class TimedShallowObjectStateCompilationContext
    extends CompilationContextBase<TimedShallowObjectState> {
        private final BinaryOperator<String> idResolver;

        private TimedShallowObjectStateCompilationContext(BinaryOperator<String> idResolver) {
            this.idResolver = idResolver;
        }

        @Override
        public EKeyedObjectType getAttributeType(String attribute) {
            if (QueryHelper.this.validColumns.containsKey(attribute)) {
                return QueryHelper.this.validColumns.get(attribute);
            }
            return EKeyedObjectType.STRING;
        }

        @Override
        public Function<TimedShallowObjectState, String> getAttributeAccessor(String attribute) {
            Integer index = QueryHelper.this.attributeIndex.get(attribute);
            return state -> state.getFrozenValue(index);
        }

        @Override
        public Predicate<TimedShallowObjectState> getAttributeEqualsIgnoreCasePredicate(String attribute, String comparisonValue, boolean lenient) {
            Integer index = QueryHelper.this.attributeIndex.get(attribute);
            return state -> IAttributeOperand.stringComparer(comparisonValue, lenient).test(state.getFrozenValue(index));
        }

        @Override
        public BinaryOperator<String> getIdResolver() {
            return this.idResolver;
        }

        @Override
        public Function<TimedShallowObjectState, String> getIdAccessor() {
            return TimedShallowObjectState::getId;
        }
    }
}

