/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.error;

import java.util.EnumSet;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.lib.commons.string.StringUtils;

public class ExpectedTypeNotFoundException
extends QueryParsingException {
    private static final long serialVersionUID = 1L;
    private final Set<EQueryTokenType> expectedKeywords;

    public ExpectedTypeNotFoundException(EQueryTokenType expectedKeywords, QueryToken actualToken) {
        this(Set.of(expectedKeywords), actualToken);
    }

    public ExpectedTypeNotFoundException(Set<EQueryTokenType> expectedKeywords, QueryToken actualToken) {
        super(ExpectedTypeNotFoundException.getMessage(expectedKeywords, actualToken), actualToken);
        this.expectedKeywords = EnumSet.copyOf(expectedKeywords);
    }

    private static String getMessage(Set<EQueryTokenType> expectedKeywords, QueryToken actualToken) {
        return "Expected keyword " + (String)expectedKeywords.stream().map(s -> "<" + String.valueOf(s) + ">").collect(StringUtils.joiningDifferentLastDelimiter((String)", ", (String)" or ")) + " but received " + actualToken.toString();
    }

    public Set<EQueryTokenType> getExpectedKeywords() {
        return EnumSet.copyOf(this.expectedKeywords);
    }
}

