/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexCreator;
import org.conqat.engine.persistence.index.IndexValidationUtils;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IStoreDecorator;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.SchemaNotFoundException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.crypto.EncryptingStore;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class IndexSchema
implements MetaIndex.IMetaIndexEntry {
    private static final long serialVersionUID = 1L;
    private final @Nullable InternalProjectId parentProjectId;
    private final Map<String, SchemaEntry> entries = new HashMap<String, SchemaEntry>();

    protected IndexSchema(Map<String, SchemaEntry> entries, @Nullable InternalProjectId parentProjectId) {
        this.parentProjectId = parentProjectId;
        this.entries.putAll(entries);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.entries, this.parentProjectId);
    }

    public Optional<String> getParentStorageSystemName() {
        return Optional.ofNullable(this.parentProjectId).map(ProjectIdBase::toString);
    }

    public SchemaEntry getEntry(String indexName) {
        return this.entries.get(indexName);
    }

    public UnmodifiableSet<String> getEntryNames() {
        return CollectionUtils.asUnmodifiable(this.entries.keySet());
    }

    <T extends IStorageIndex> T openIndex(Class<T> indexClass, String indexName, IStorageSystem storageSystem, IndexCreator indexCreator, @Nullable HistoryAccessOption historyAccessOption, @Nullable FunctionWithException<String, IStore, StorageException> virtualStoreResolver, IStoreDecorator decorator) throws StorageException {
        IStore store = this.openStoreChecked(indexClass, indexName, storageSystem, false, historyAccessOption, virtualStoreResolver, decorator);
        return indexCreator.createIndex(indexClass, store);
    }

    public IStore openStoreChecked(Class<? extends IStorageIndex> indexClass, String storeName, IStorageSystem storageSystem, boolean rawAccess, @Nullable HistoryAccessOption historyAccessOption) throws StorageException {
        return this.openStoreChecked(indexClass, storeName, storageSystem, rawAccess, historyAccessOption, null, null);
    }

    public IStore openStoreChecked(Class<? extends IStorageIndex> indexClass, String storeName, IStorageSystem storageSystem, boolean rawAccess, @Nullable HistoryAccessOption historyAccessOption, @Nullable FunctionWithException<String, IStore, StorageException> virtualStoreResolver, @Nullable IStoreDecorator decorator) throws StorageException {
        return IndexSchema.openStoreForEntry(indexClass, storeName, storageSystem, rawAccess, historyAccessOption, this.getNonNullEntry(storeName), virtualStoreResolver, decorator);
    }

    private SchemaEntry getNonNullEntry(String storeName) throws StorageException {
        SchemaEntry entry = this.getEntry(storeName);
        if (entry == null) {
            throw new StorageException("No schema entry for store '" + storeName + "' found!");
        }
        return entry;
    }

    private static IStore openStoreForEntry(Class<? extends IStorageIndex> indexClass, String storeName, IStorageSystem storageSystem, boolean rawAccess, @Nullable HistoryAccessOption historyAccessOption, SchemaEntry entry, @Nullable FunctionWithException<String, IStore, StorageException> virtualStoreResolver, @Nullable IStoreDecorator decorator) throws StorageException, AssertionError {
        if (entry.getIndexClass().equals(DummyIndex.class.getName())) {
            throw new StorageException("Can't open index with schema entry for dummy index.");
        }
        if (!indexClass.getName().equals(entry.getIndexClass())) {
            throw new StorageException("Index classes do not match for '" + storeName + "'. Schema requires " + entry.getIndexClass() + " but caller requested " + indexClass.getName());
        }
        try {
            IStore store;
            if (entry.getStorageOptions().contains((Object)EStorageOption.VIRTUAL)) {
                if (virtualStoreResolver == null) {
                    throw new StorageException("Can not open store '" + storeName + "' as this is marked as virtual and no virtual store resolver was provided!");
                }
                store = (IStore)virtualStoreResolver.apply((Object)storeName);
            } else {
                store = storageSystem.openStore(storeName);
            }
            return IndexSchema.applyStoreOptions(entry, store, rawAccess, historyAccessOption, storageSystem, decorator);
        }
        catch (AssertionError e) {
            throw new AssertionError("Failed to open store '" + storeName + "' of index '" + indexClass.getSimpleName() + "'", (Throwable)((Object)e));
        }
    }

    public IBranchingLayer openBranchingLayer(Class<? extends IStorageIndex> indexClass, String storeName, IStorageSystem storageSystem) throws StorageException {
        SchemaEntry schemaEntry = this.getNonNullEntry(storeName);
        IStore baseStore = IndexSchema.openStoreForEntry(indexClass, storeName, storageSystem, true, null, schemaEntry, null, null);
        return IBranchingLayer.create(baseStore, schemaEntry);
    }

    public static IStore applyStoreOptions(SchemaEntry entry, IStore store, boolean rawAccess, @Nullable HistoryAccessOption historyAccessOption, IStorageSystem storageSystem, @Nullable IStoreDecorator decorator) throws StorageException {
        if (EncryptedStorageHandler.isEncrypted(entry) && !(store instanceof EncryptingStore)) {
            store = new EncryptingStore(store);
        }
        if (entry.usesOption(EStorageOption.COMPRESSED)) {
            store = new CompressingStore(store);
        }
        CCSMAssert.isFalse((rawAccess && historyAccessOption != null ? 1 : 0) != 0, (String)("Unexpected history option " + String.valueOf(historyAccessOption) + " for raw access to " + String.valueOf(entry)));
        if (!rawAccess) {
            if (entry.isHistorized()) {
                CCSMAssert.isNotNull((Object)historyAccessOption, (String)("No history access option provided for historized store " + String.valueOf(entry)));
                store = historyAccessOption.createStore(store, entry);
                if (entry.usesOption(EStorageOption.BRANCHED)) {
                    CCSMAssert.isFalse((boolean)historyAccessOption.isUnbranched(), (String)("No branch name is provided for branched store " + String.valueOf(entry)));
                }
            } else {
                CCSMAssert.isTrue((historyAccessOption == null ? 1 : 0) != 0, (String)("Unexpected history access option " + String.valueOf(historyAccessOption) + " for non-historized store " + String.valueOf(entry)));
            }
        }
        if (decorator != null) {
            store = decorator.decorate(store);
        }
        if (!rawAccess && entry.usesOption(EStorageOption.ABBREVIATE_STRINGS)) {
            store = IndexSchema.wrapWithStringAbbreviationSupport(entry, store, storageSystem);
        }
        return store;
    }

    private static @NonNull IStore wrapWithStringAbbreviationSupport(SchemaEntry entry, IStore store, IStorageSystem storageSystem) {
        CCSMAssert.isFalse((storageSystem == null ? 1 : 0) != 0, (String)"Storage system must be provided if string abbreviation is used!");
        CCSMAssert.isFalse((boolean)entry.usesOption(EStorageOption.BACKUP), (String)"May not combine string abbreviation with backup, as the abbreviations are not part of the backup.");
        IStorageAbbreviator abbreviator = storageSystem.getAbbreviator();
        return new StoreWithAbbreviationSupport(store, abbreviator);
    }

    public static IndexSchema load(IStorageSystem storageSystem, SynchronizedCacheAccess<IndexSchemaCache> schemaCacheAccess) throws StorageException {
        return (IndexSchema)schemaCacheAccess.getOrUpdate(schemaCache -> IndexSchema.loadFromCache(storageSystem, schemaCache));
    }

    private static IndexSchema loadFromCache(IStorageSystem storageSystem, IndexSchemaCache schemaCache) throws StorageException {
        IndexSchema cachedSchema = schemaCache.getCachedSchema();
        if (cachedSchema != null) {
            return cachedSchema;
        }
        IndexSchema schema = IndexSchema.loadInternal(storageSystem);
        if (schema == null) {
            throw new SchemaNotFoundException("Schema is missing from storage system.");
        }
        schemaCache.setCachedSchema(schema);
        return schema;
    }

    private static IndexSchema loadInternal(IStorageSystem storageSystem) throws StorageException {
        IStore store = storageSystem.openStore("_meta");
        return new MetaIndex(store).getValue(IndexSchema.class);
    }

    public static boolean hasSchema(IStorageSystem storageSystem) throws StorageException {
        return IndexSchema.loadInternal(storageSystem) != null;
    }

    public boolean isStoreUsingOption(String storeName, EStorageOption storageOption) {
        SchemaEntry entry = this.getEntry(storeName);
        CCSMAssert.isNotNull((Object)entry, (String)("No such store: " + storeName));
        return entry.usesOption(storageOption);
    }

    public void save(IStorageSystem storageSystem, SynchronizedCacheAccess<IndexSchemaCache> schemaCacheAccess) throws StorageException {
        IStore store = storageSystem.openStore("_meta");
        new MetaIndex(store).setValue(this, IndexSchema.class);
        schemaCacheAccess.invalidate("Updated schema!");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String storeName : CollectionUtils.sort(this.entries.keySet())) {
            SchemaEntry entry = this.entries.get(storeName);
            sb.append(storeName).append(":").append(entry.getIndexClass());
            for (EStorageOption option : entry.getStorageOptions()) {
                sb.append(":").append(option.name());
            }
            sb.append(StringUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static class Builder {
        private @Nullable InternalProjectId parentProjectId = null;
        private final Map<String, SchemaEntry> entries = new HashMap<String, SchemaEntry>();

        private Builder() {
        }

        private Builder(Map<String, SchemaEntry> entries, @Nullable InternalProjectId parentProjectId) {
            this.entries.putAll(entries);
            this.parentProjectId = parentProjectId;
        }

        public IndexSchema build() {
            return new IndexSchema(this.entries, this.parentProjectId);
        }

        public SchemaEntry getEntry(String indexName) {
            return this.entries.get(indexName);
        }

        public UnmodifiableSet<String> getEntryNames() {
            return CollectionUtils.asUnmodifiable(this.entries.keySet());
        }

        public Builder setParentProjectId(@Nullable InternalProjectId parentProjectId) {
            this.parentProjectId = parentProjectId;
            return this;
        }

        public void updateGlobalEntry(Class<? extends IGlobalIndex> globalIndex) {
            this.updateEntry(globalIndex, null);
        }

        public Builder updateProjectEntry(Class<? extends IProjectIndex> projectIndex) {
            this.updateEntry(projectIndex, null);
            return this;
        }

        public void updateProjectEntries(Collection<Class<? extends IProjectIndex>> projectIndexes) {
            for (Class<? extends IProjectIndex> projectIndex : projectIndexes) {
                this.updateEntry(projectIndex, null);
            }
        }

        public Builder updateProjectEntry(Class<? extends IProjectIndexWithDynamicName> projectIndex, String indexName) {
            this.updateEntry(projectIndex, Objects.requireNonNull(indexName, "indexName"));
            return this;
        }

        private void updateEntry(Class<? extends IStorageIndex> storageIndex, @Nullable String indexName) {
            IndexValidationUtils.validateIndexClass(storageIndex);
            Index indexAnnotation = IStorageIndex.getIndexAnnotation(storageIndex);
            this.updateWithSchemaEntry(Objects.requireNonNullElseGet(indexName, indexAnnotation::name), new SchemaEntry(storageIndex, indexAnnotation));
        }

        public Builder updateWithSchemaEntry(String indexName, SchemaEntry entry) {
            if (entry == null) {
                this.entries.remove(indexName);
            } else {
                this.entries.put(indexName, entry);
            }
            return this;
        }
    }

    protected static final class DummyIndex
    implements IGlobalIndex {
        private DummyIndex() {
        }
    }
}

