/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.KeyCountingCallback;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StringKeyCollectingCallback;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class StorageUtils {
    public static final int RECORD_TERMINATOR = -1;
    private static final long MIN_READ_BYTES = ByteUnit.MEBIBYTES.toBytes(1L);

    public static List<String> listStringKeys(IStore store) throws StorageException {
        ArrayList<String> result = new ArrayList<String>();
        store.scanKeys(new byte[0], (IKeyValueCallback)new StringKeyCollectingCallback(result));
        return result;
    }

    public static PairList<String, byte[]> listStringKeysAndValues(IStore store) throws StorageException {
        PairList result = new PairList();
        store.scan(new byte[0], (key, value) -> {
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)StringUtils.bytesToString((byte[])key), (Object)value);
            }
        });
        return result;
    }

    public static List<byte[]> listKeys(IStore store) throws StorageException {
        return StorageUtils.listKeysStartingWith(new byte[0], store);
    }

    public static List<byte[]> listKeysStartingWith(@NonNull String prefix, IStore store) throws StorageException {
        return StorageUtils.listKeysStartingWith(StringUtils.stringToBytes((String)prefix), store);
    }

    public static List<byte[]> listKeysStartingWith(byte @NonNull [] prefix, IStore store) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        KeyCollectingCallback callback = new KeyCollectingCallback(keys);
        store.scanKeys(prefix, (IKeyValueCallback)callback);
        return keys;
    }

    public static void batchProcessKeys(IStore store, final int batchSize, final ConsumerWithException<List<byte[]>, StorageException> processor) throws StorageException {
        final ArrayList keys = new ArrayList();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                keys.add(key);
                if (keys.size() >= batchSize) {
                    processor.accept((Object)keys);
                    keys.clear();
                }
            }
        };
        store.scanKeys(new byte[0], (IKeyValueCallback)callback);
        callback.throwCaughtException();
        if (!keys.isEmpty()) {
            processor.accept(keys);
        }
    }

    public static void scanWithPrefixExcluding(String prefix, String excludedPrefix, IKeyValueCallback callback, IStore store) throws StorageException {
        StorageUtils.scanWithPrefixExcluding(StringUtils.stringToBytes((String)prefix), StringUtils.stringToBytes((String)excludedPrefix), callback, store);
    }

    private static void scanWithPrefixExcluding(byte[] prefix, byte[] excludedPrefix, IKeyValueCallback callback, IStore store) throws StorageException {
        if (ByteArrayUtils.isPrefix((byte[])excludedPrefix, (byte[])prefix)) {
            return;
        }
        if (!ByteArrayUtils.isPrefix((byte[])prefix, (byte[])excludedPrefix)) {
            store.scan(prefix, callback);
            return;
        }
        store.scan(prefix, excludedPrefix, callback);
        store.scan(StorageUtils.generatePrefixEndKey(excludedPrefix), StorageUtils.generatePrefixEndKey(prefix), callback);
    }

    public static int keyCount(IStore store) throws StorageException {
        KeyCountingCallback callback = new KeyCountingCallback();
        store.scanKeys(new byte[0], (IKeyValueCallback)callback);
        return callback.getNumberOfKeys();
    }

    public static void clearStore(IStore store) throws StorageException {
        if (store instanceof InMemoryStore) {
            ((InMemoryStore)store).clear();
        } else {
            store.removeByPrefix(new byte[0]);
        }
    }

    public static void clearStore(IStorageSystem storageSystem, String store) throws StorageException {
        StorageUtils.clearStore(storageSystem.openStore(store));
    }

    public static int exportStore(IStore store, DataOutputStream out) throws StorageException, IOException {
        StreamWritingCallback callback = new StreamWritingCallback(out);
        store.scan(new byte[0], (IKeyValueCallback)callback);
        if (callback.exception != null) {
            throw callback.exception;
        }
        out.writeInt(-1);
        return callback.recordCount;
    }

    public static int importStore(IStore store, DataInputStream in) throws IOException, StorageException {
        try {
            return StorageUtils.importStore(store, in, ICancelable.neverCanceled());
        }
        catch (ExecutionCanceledException e) {
            return (Integer)CCSMAssert.fail((String)"Exception should never be thrown", (Throwable)e);
        }
    }

    public static int importStore(IStore store, DataInputStream in, ICancelable cancelable) throws IOException, StorageException, ExecutionCanceledException {
        int recordCount = 0;
        int byteCount = 0;
        PairList data = new PairList();
        while (true) {
            int keySize;
            if ((keySize = in.readInt()) == -1) {
                store.put((PairList<byte[], byte[]>)data);
                return recordCount;
            }
            byte[] key = new byte[keySize];
            FileSystemUtils.safeRead((InputStream)in, (byte[])key);
            int valueSize = in.readInt();
            byte[] value = new byte[valueSize];
            FileSystemUtils.safeRead((InputStream)in, (byte[])value);
            data.add((Object)key, (Object)value);
            ++recordCount;
            if ((long)(byteCount += keySize + valueSize) < MIN_READ_BYTES) continue;
            store.put((PairList<byte[], byte[]>)data);
            byteCount = 0;
            data.clear();
            cancelable.verifyNotCanceled();
        }
    }

    public static PairList<byte[], byte[]> readStore(DataInputStream in) throws IOException {
        PairList data = new PairList();
        int keySize;
        while ((keySize = in.readInt()) != -1) {
            byte[] key = new byte[keySize];
            FileSystemUtils.safeRead((InputStream)in, (byte[])key);
            int valueSize = in.readInt();
            byte[] value = new byte[valueSize];
            FileSystemUtils.safeRead((InputStream)in, (byte[])value);
            data.add((Object)key, (Object)value);
        }
        return data;
    }

    public static <T extends Serializable> T deserialize(byte @Nullable [] value) throws StorageException {
        try {
            return (T)SerializationUtils.deserializeFromByteArray((byte[])value);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new StorageException(e);
        }
    }

    public static <T extends Serializable> List<T> deserializeValues(List<byte[]> values) throws StorageException {
        return CollectionUtils.mapWithException(values, StorageUtils::deserialize);
    }

    public static byte[] serialize(Serializable value) throws StorageException {
        try {
            return SerializationUtils.serializeToByteArray((Serializable)value);
        }
        catch (IOException e) {
            throw new StorageException("Error during serialization of " + String.valueOf(value), e);
        }
    }

    public static void deleteRange(ConvenientStore store, byte[] begin, byte[] end) throws StorageException {
        StorageUtils.deleteRange(store, begin, end, key -> true);
    }

    public static void deleteRange(ConvenientStore store, byte[] begin, byte[] end, Predicate<byte[]> predicate) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        KeyCollectingCallback callback = new KeyCollectingCallback(keys);
        store.scanKeys(begin, end, callback);
        store.remove(CollectionUtils.filter(keys, predicate));
    }

    public static String serializeStoreForTest(IStore store) throws StorageException {
        final ArrayList lines = new ArrayList();
        store.scan(new byte[0], new IKeyValueCallback(){

            @Override
            public synchronized void callback(byte[] key, byte[] value) {
                lines.add(StringUtils.encodeAsHex((byte[])key) + " = " + StringUtils.encodeAsHex((byte[])value));
            }
        });
        return StringUtils.concat((Iterable)CollectionUtils.sort(lines), (String)StringUtils.LINE_SEPARATOR);
    }

    public static void writeCompactObject(Object value, DataOutput out) throws IOException {
        CounterSet set;
        if (value == null) {
            out.writeByte(0);
        } else if (value instanceof Integer) {
            out.writeByte(1);
            out.writeInt((Integer)value);
        } else if (value instanceof Double) {
            StorageUtils.writeDoubleValue(out, (Double)value);
        } else if (value instanceof Long) {
            out.writeByte(4);
            out.writeLong((Long)value);
        } else if (value instanceof String) {
            out.writeByte(5);
            out.writeUTF((String)value);
        } else if (value instanceof Assessment) {
            out.writeByte(6);
            StorageUtils.writeAssessment((Assessment)value, out);
        } else if (value instanceof CounterSet && ((set = (CounterSet)value).isEmpty() || CollectionUtils.getAny((Iterable)set.getKeys()) instanceof String)) {
            out.writeByte(7);
            StorageUtils.writeCounterSetWithStringKeys(set, out);
        } else if (value instanceof Serializable) {
            StorageUtils.writeSerializable(out, (Serializable)value);
        } else {
            throw new IOException("Don't know how to serialize a " + String.valueOf(value.getClass()));
        }
    }

    private static void writeCounterSetWithStringKeys(CounterSet<?> e, DataOutput out) throws IOException {
        out.writeInt(e.getKeys().size());
        for (Pair pair : e) {
            String key = (String)pair.getFirst();
            out.writeUTF(key);
            out.writeInt((Integer)pair.getSecond());
        }
    }

    public static byte[] serializeCompactObject(Object value) throws StorageException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            StorageUtils.writeCompactObject(value, dos);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return baos.toByteArray();
    }

    public static Object readCompactObject(DataInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return in.readInt();
            }
            case 2: {
                return (double)in.readInt();
            }
            case 3: {
                return in.readDouble();
            }
            case 4: {
                return in.readLong();
            }
            case 5: {
                return in.readUTF();
            }
            case 6: {
                return StorageUtils.readAssessment(in);
            }
            case 7: {
                return StorageUtils.readCounterSetWithStringKeys(in);
            }
            case 127: {
                byte[] data = new byte[in.readInt()];
                in.readFully(data);
                try {
                    return SerializationUtils.deserializeFromByteArray((byte[])data);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        }
        throw new IOException("Unknown/unsupported type: " + type);
    }

    private static CounterSet<String> readCounterSetWithStringKeys(DataInput in) throws IOException {
        CounterSet result = new CounterSet();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            String key = in.readUTF();
            int value = in.readInt();
            result.inc((Object)key, value);
        }
        return result;
    }

    public static Object deserializeCompactObject(byte[] value) throws StorageException {
        Object object;
        if (value == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(value));
        try {
            object = StorageUtils.readCompactObject(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        in.close();
        return object;
    }

    private static void writeAssessment(Assessment assessment, DataOutput out) throws IOException {
        CCSMAssert.isTrue((ETrafficLightColor.values().length <= 6 ? 1 : 0) != 0, (String)"This code relies on the fact that we have at most 6 traffic light colors!");
        boolean compact = assessment.getSize() < 128;
        int usedColors = 0;
        if (compact) {
            usedColors = 1;
        }
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            usedColors <<= 1;
            if (assessment.getColorFrequency(color) <= 0) continue;
            usedColors |= 1;
        }
        out.writeByte(usedColors);
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            int colorFrequency = assessment.getColorFrequency(color);
            if (colorFrequency <= 0) continue;
            if (compact) {
                out.writeByte(colorFrequency);
                continue;
            }
            out.writeInt(colorFrequency);
        }
    }

    private static void writeSerializable(DataOutput out, Serializable serializable) throws IOException {
        out.writeByte(127);
        byte[] serialized = SerializationUtils.serializeToByteArray((Serializable)serializable);
        out.writeInt(serialized.length);
        out.write(serialized);
    }

    private static void writeDoubleValue(DataOutput out, double doubleValue) throws IOException {
        int intValue = (int)doubleValue;
        if ((double)intValue == doubleValue) {
            out.writeByte(2);
            out.writeInt(intValue);
        } else {
            out.writeByte(3);
            out.writeDouble(doubleValue);
        }
    }

    private static Object readAssessment(DataInput in) throws IOException {
        int mask;
        byte usedColors = in.readByte();
        boolean compact = (usedColors & (mask = 1 << ETrafficLightColor.values().length)) != 0;
        Assessment assessment = new Assessment();
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            if ((usedColors & (mask >>= 1)) == 0) continue;
            if (compact) {
                assessment.add(color, (int)in.readByte());
                continue;
            }
            assessment.add(color, in.readInt());
        }
        return assessment;
    }

    public static ArrayList<String> deserializeStringList(byte[] value) throws StorageException {
        return (ArrayList)StorageUtils.deserialize(value);
    }

    public static void copyStore(IStore readStore, IStore writeStore) throws StorageException {
        CopyingKeyValueCallback callback = new CopyingKeyValueCallback(writeStore);
        readStore.scan(new byte[0], (IKeyValueCallback)callback);
        callback.completeCopying();
    }

    public static byte[] generatePrefixEndKey(byte[] prefix) {
        int lastIndex;
        for (lastIndex = prefix.length - 1; lastIndex >= 0 && prefix[lastIndex] == -1; --lastIndex) {
        }
        byte[] end = null;
        if (lastIndex >= 0) {
            end = Arrays.copyOfRange(prefix, 0, lastIndex + 1);
            int n = lastIndex;
            end[n] = (byte)(end[n] + 1);
        }
        return end;
    }

    public static IStore createInMemoryCopy(IStore inputStore) throws StorageException {
        InMemoryStore copy = new InMemoryStore();
        StorageUtils.copyStore(inputStore, copy);
        return copy;
    }

    public static @Nullable StorageStringAbbreviator getAbbreviatorFromStore(IStore store) {
        if (store instanceof StoreWithAbbreviationSupport) {
            return ((StoreWithAbbreviationSupport)store).getStringAbbreviator();
        }
        return null;
    }

    private StorageUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    @ThreadSafe
    private static final class StreamWritingCallback
    implements IKeyValueCallback {
        private final DataOutputStream outputStream;
        private IOException exception;
        private int recordCount = 0;

        private StreamWritingCallback(DataOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void callback(byte[] key, byte[] value) {
            try {
                DataOutputStream dataOutputStream = this.outputStream;
                synchronized (dataOutputStream) {
                    this.outputStream.writeInt(key.length);
                    this.outputStream.write(key);
                    this.outputStream.writeInt(value.length);
                    this.outputStream.write(value);
                    ++this.recordCount;
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }

    @ThreadSafe
    private static final class CopyingKeyValueCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private static final int MAX_BUFFER_SIZE = 1000;
        private final IStore writeStore;
        private final PairList<byte[], byte[]> buffer = new PairList();

        private CopyingKeyValueCallback(IStore writeStore) {
            this.writeStore = writeStore;
        }

        @Override
        protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
            this.buffer.add((Object)key, (Object)value);
            if (this.buffer.size() >= 1000) {
                this.writeStore.put(this.buffer);
                this.buffer.clear();
            }
        }

        private void completeCopying() throws StorageException {
            if (!this.buffer.isEmpty()) {
                this.writeStore.put(this.buffer);
            }
            this.throwCaughtException();
        }
    }
}

