/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.AuthHelper;
import ru.bozaro.gitlfs.client.HttpExecutor;
import ru.bozaro.gitlfs.client.auth.AuthProvider;
import ru.bozaro.gitlfs.client.exceptions.ForbiddenException;
import ru.bozaro.gitlfs.client.exceptions.UnauthorizedException;
import ru.bozaro.gitlfs.client.internal.HttpClientExecutor;
import ru.bozaro.gitlfs.client.internal.JsonPost;
import ru.bozaro.gitlfs.client.internal.LockCreate;
import ru.bozaro.gitlfs.client.internal.LockDelete;
import ru.bozaro.gitlfs.client.internal.LocksList;
import ru.bozaro.gitlfs.client.internal.MetaGet;
import ru.bozaro.gitlfs.client.internal.MetaPost;
import ru.bozaro.gitlfs.client.internal.ObjectGet;
import ru.bozaro.gitlfs.client.internal.ObjectPut;
import ru.bozaro.gitlfs.client.internal.ObjectVerify;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.client.internal.Work;
import ru.bozaro.gitlfs.client.io.StreamHandler;
import ru.bozaro.gitlfs.client.io.StreamProvider;
import ru.bozaro.gitlfs.common.JsonHelper;
import ru.bozaro.gitlfs.common.LockConflictException;
import ru.bozaro.gitlfs.common.VerifyLocksResult;
import ru.bozaro.gitlfs.common.data.BatchReq;
import ru.bozaro.gitlfs.common.data.BatchRes;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.LinkType;
import ru.bozaro.gitlfs.common.data.Links;
import ru.bozaro.gitlfs.common.data.Lock;
import ru.bozaro.gitlfs.common.data.LocksRes;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.data.ObjectRes;
import ru.bozaro.gitlfs.common.data.Operation;
import ru.bozaro.gitlfs.common.data.Ref;
import ru.bozaro.gitlfs.common.data.VerifyLocksReq;
import ru.bozaro.gitlfs.common.data.VerifyLocksRes;
import ru.bozaro.gitlfs.common.io.InputStreamValidator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0002JKB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J9\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$J'\u0010'\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010#\u001a\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001b0)\u00a2\u0006\u0002\u0010*J1\u0010'\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001b0)\u00a2\u0006\u0002\u0010/J*\u00100\u001a\b\u0012\u0004\u0012\u000202012\b\u00103\u001a\u0004\u0018\u00010$2\b\u00104\u001a\u0004\u0018\u00010$2\b\u00105\u001a\u0004\u0018\u000106J\u0018\u00107\u001a\u0002022\u0006\u00103\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u000106J\u000e\u00108\u001a\u0002092\u0006\u0010#\u001a\u00020$J\u0018\u00108\u001a\u0002092\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u0018\u0010>\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010?\u001a\u00020@J\u0010\u0010>\u001a\u0004\u0018\u00010\"2\u0006\u0010+\u001a\u00020,J\u001e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010#\u001a\u00020$2\u0006\u0010?\u001a\u00020@J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\b\b\u0002\u0010+\u001a\u00020,J\u001e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\"\u0010E\u001a\u0004\u0018\u0001022\u0006\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020B2\b\u00105\u001a\u0004\u0018\u000106J\"\u0010E\u001a\u0004\u0018\u0001022\u0006\u00107\u001a\u0002022\u0006\u0010G\u001a\u00020B2\b\u00105\u001a\u0004\u0018\u000106J\u0010\u0010H\u001a\u00020I2\b\u00105\u001a\u0004\u0018\u000106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lru/bozaro/gitlfs/client/Client;", "Ljava/io/Closeable;", "authProvider", "Lru/bozaro/gitlfs/client/auth/AuthProvider;", "http", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lru/bozaro/gitlfs/client/auth/AuthProvider;Lorg/apache/http/impl/client/CloseableHttpClient;)V", "Lru/bozaro/gitlfs/client/HttpExecutor;", "(Lru/bozaro/gitlfs/client/auth/AuthProvider;Lru/bozaro/gitlfs/client/HttpExecutor;)V", "getAuthProvider", "()Lru/bozaro/gitlfs/client/auth/AuthProvider;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "close", "", "doRequest", "R", "link", "Lru/bozaro/gitlfs/common/data/Link;", "task", "Lru/bozaro/gitlfs/client/internal/Request;", "url", "Ljava/net/URI;", "autoClose", "Lru/bozaro/gitlfs/client/Client$ConnectionClosePolicy;", "(Lru/bozaro/gitlfs/common/data/Link;Lru/bozaro/gitlfs/client/internal/Request;Ljava/net/URI;Lru/bozaro/gitlfs/client/Client$ConnectionClosePolicy;)Ljava/lang/Object;", "doWork", "T", "work", "Lru/bozaro/gitlfs/client/internal/Work;", "operation", "Lru/bozaro/gitlfs/common/data/Operation;", "(Lru/bozaro/gitlfs/client/internal/Work;Lru/bozaro/gitlfs/common/data/Operation;)Ljava/lang/Object;", "getLinks", "Lru/bozaro/gitlfs/common/data/ObjectRes;", "hash", "", "auth", "getMeta", "getObject", "handler", "Lru/bozaro/gitlfs/client/io/StreamHandler;", "(Ljava/lang/String;Lru/bozaro/gitlfs/client/io/StreamHandler;)Ljava/lang/Object;", "meta", "Lru/bozaro/gitlfs/common/data/Meta;", "links", "Lru/bozaro/gitlfs/common/data/Links;", "(Lru/bozaro/gitlfs/common/data/Meta;Lru/bozaro/gitlfs/common/data/Links;Lru/bozaro/gitlfs/client/io/StreamHandler;)Ljava/lang/Object;", "listLocks", "", "Lru/bozaro/gitlfs/common/data/Lock;", "path", "id", "ref", "Lru/bozaro/gitlfs/common/data/Ref;", "lock", "openObject", "Ljava/io/InputStream;", "postBatch", "Lru/bozaro/gitlfs/common/data/BatchRes;", "batchReq", "Lru/bozaro/gitlfs/common/data/BatchReq;", "postMeta", "size", "", "putObject", "", "streamProvider", "Lru/bozaro/gitlfs/client/io/StreamProvider;", "unlock", "lockId", "force", "verifyLocks", "Lru/bozaro/gitlfs/common/VerifyLocksResult;", "Companion", "ConnectionClosePolicy", "gitlfs-client"})
public final class Client
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthProvider authProvider;
    @NotNull
    private final HttpExecutor http;
    @NotNull
    private final ObjectMapper mapper;
    private static final int MAX_AUTH_COUNT = 1;
    private static final int MAX_RETRY_COUNT = 2;
    private static final int MAX_REDIRECT_COUNT = 5;

    public Client(@NotNull AuthProvider authProvider, @NotNull HttpExecutor http) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        this.authProvider = authProvider;
        this.http = http;
        this.mapper = JsonHelper.INSTANCE.getMapper();
    }

    @NotNull
    public final AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public Client(@NotNull AuthProvider authProvider, @NotNull CloseableHttpClient http) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        this(authProvider, new HttpClientExecutor(http));
    }

    public /* synthetic */ Client(AuthProvider authProvider, CloseableHttpClient closeableHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            CloseableHttpClient closeableHttpClient2 = HttpClients.createDefault();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient2, (String)"createDefault()");
            closeableHttpClient = closeableHttpClient2;
        }
        this(authProvider, closeableHttpClient);
    }

    @Nullable
    public final ObjectRes getMeta(@NotNull String hash) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.doWork(arg_0 -> Client.getMeta$lambda$0(this, hash, arg_0), Operation.Download);
    }

    private final <T> T doWork(Work<T> work, Operation operation) throws IOException {
        Link auth = this.authProvider.getAuth(operation);
        int authCount = 0;
        while (true) {
            Link link;
            Link newAuth;
            try {
                return work.exec(auth);
            }
            catch (UnauthorizedException e) {
                if (authCount >= 1) {
                    throw e;
                }
                ++authCount;
                this.authProvider.invalidateAuth(operation, auth);
                newAuth = this.authProvider.getAuth(operation);
                if (Intrinsics.areEqual((Object)newAuth.getHeader(), (Object)auth.getHeader()) && Intrinsics.areEqual((Object)newAuth.getHref(), (Object)auth.getHref())) {
                    throw e;
                }
                link = newAuth;
            }
            catch (ForbiddenException e) {
                if (authCount >= 1) {
                    throw e;
                }
                ++authCount;
                this.authProvider.invalidateAuth(operation, auth);
                newAuth = this.authProvider.getAuth(operation);
                if (Intrinsics.areEqual((Object)newAuth.getHeader(), (Object)auth.getHeader()) && Intrinsics.areEqual((Object)newAuth.getHref(), (Object)auth.getHref())) {
                    throw e;
                }
                link = newAuth;
            }
            auth = link;
        }
    }

    /*
     * Exception decompiling
     */
    public final <R> R doRequest(@Nullable Link link, @NotNull Request<R> task, @NotNull URI url, @NotNull ConnectionClosePolicy autoClose) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean putObject(@NotNull StreamProvider streamProvider, @NotNull String hash, long size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.putObject(streamProvider, new Meta(hash, size));
    }

    public final boolean putObject(@NotNull StreamProvider streamProvider, @NotNull Meta meta) throws IOException {
        Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        return this.doWork(arg_0 -> Client.putObject$lambda$1(this, meta, streamProvider, arg_0), Operation.Upload);
    }

    public static /* synthetic */ boolean putObject$default(Client client, StreamProvider streamProvider, Meta meta, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            meta = Companion.generateMeta(streamProvider);
        }
        return client.putObject(streamProvider, meta);
    }

    public final boolean putObject(@NotNull StreamProvider streamProvider, @NotNull Meta meta, @NotNull Links links) throws IOException {
        Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        Link link = (Link)links.getLinks().get(LinkType.Upload);
        if (link == null) {
            return false;
        }
        Link uploadLink = link;
        this.doRequest(uploadLink, new ObjectPut(streamProvider, meta.getSize()), uploadLink.getHref(), ConnectionClosePolicy.Close);
        Link verifyLink = (Link)links.getLinks().get(LinkType.Verify);
        if (verifyLink != null) {
            this.doRequest(verifyLink, new ObjectVerify(meta), verifyLink.getHref(), ConnectionClosePolicy.Close);
        }
        return true;
    }

    @Nullable
    public final ObjectRes postMeta(@NotNull String hash, long size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.postMeta(new Meta(hash, size));
    }

    @Nullable
    public final ObjectRes postMeta(@NotNull Meta meta) throws IOException {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        return this.doWork(arg_0 -> Client.postMeta$lambda$2(this, meta, arg_0), Operation.Upload);
    }

    @NotNull
    public final BatchRes postBatch(@NotNull BatchReq batchReq) throws IOException {
        Intrinsics.checkNotNullParameter((Object)batchReq, (String)"batchReq");
        return this.doWork(arg_0 -> Client.postBatch$lambda$3(this, batchReq, arg_0), batchReq.getOperation());
    }

    public final <T> T getObject(@NotNull String hash, @NotNull StreamHandler<T> handler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return (T)this.doWork(arg_0 -> Client.getObject$lambda$4(this, hash, handler, arg_0), Operation.Download);
    }

    private final ObjectRes getLinks(String hash, Link auth) throws IOException {
        String[] stringArray = new String[]{"objects/", hash};
        ObjectRes objectRes = (ObjectRes)this.doRequest(auth, new MetaGet(), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
        if (objectRes == null) {
            throw new FileNotFoundException();
        }
        return objectRes;
    }

    public final <T> T getObject(@Nullable Meta meta, @NotNull Links links, @NotNull StreamHandler<T> handler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Link link = (Link)links.getLinks().get(LinkType.Download);
        if (link == null) {
            throw new FileNotFoundException();
        }
        Link link2 = link;
        return (T)this.doRequest(link2, (Request)new ObjectGet<Object>(arg_0 -> Client.getObject$lambda$5(handler, meta, arg_0)), link2.getHref(), ConnectionClosePolicy.Close);
    }

    @NotNull
    public final InputStream openObject(@NotNull String hash) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.doWork(arg_0 -> Client.openObject$lambda$6(this, hash, arg_0), Operation.Download);
    }

    @NotNull
    public final InputStream openObject(@Nullable Meta meta, @NotNull Links links) throws IOException {
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        Link link = (Link)links.getLinks().get(LinkType.Download);
        if (link == null) {
            throw new FileNotFoundException();
        }
        Link link2 = link;
        return (InputStream)this.doRequest(link2, (Request)new ObjectGet<InputStream>(arg_0 -> Client.openObject$lambda$7(meta, arg_0)), link2.getHref(), ConnectionClosePolicy.DoNotClose);
    }

    @NotNull
    public final Lock lock(@NotNull String path, @Nullable Ref ref) throws IOException, LockConflictException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LockCreate.Res res = this.doWork(arg_0 -> Client.lock$lambda$8(this, path, ref, arg_0), Operation.Upload);
        if (!res.isSuccess()) {
            throw new LockConflictException(res.getMessage(), res.getLock());
        }
        return res.getLock();
    }

    @Nullable
    public final Lock unlock(@NotNull Lock lock, boolean force, @Nullable Ref ref) throws IOException {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        return this.unlock(lock.getId(), force, ref);
    }

    @Nullable
    public final Lock unlock(@NotNull String lockId, boolean force, @Nullable Ref ref) throws IOException {
        Intrinsics.checkNotNullParameter((Object)lockId, (String)"lockId");
        return this.doWork(arg_0 -> Client.unlock$lambda$9(this, force, ref, lockId, arg_0), Operation.Upload);
    }

    @NotNull
    public final List<Lock> listLocks(@Nullable String path, @Nullable String id, @Nullable Ref ref) throws IOException {
        LocksRes res;
        List result = new ArrayList();
        StringBuffer baseParams = new StringBuffer();
        Client.Companion.appendOptionalParam(baseParams, "path", path);
        Client.Companion.appendOptionalParam(baseParams, "id", id);
        if (ref != null) {
            Client.Companion.appendOptionalParam(baseParams, "refspec", ref.getName());
        }
        String cursor = null;
        do {
            String cursorFinal = cursor;
            StringBuffer params = new StringBuffer(baseParams);
            Client.Companion.appendOptionalParam(params, "cursor", cursorFinal);
            res = this.doWork(arg_0 -> Client.listLocks$lambda$10(this, params, arg_0), Operation.Download);
            result.addAll(res.getLocks());
        } while ((cursor = res.getNextCursor()) != null && ((CharSequence)cursor).length() > 0);
        return result;
    }

    @NotNull
    public final VerifyLocksResult verifyLocks(@Nullable Ref ref) throws IOException {
        VerifyLocksRes res;
        ArrayList ourLocks = new ArrayList();
        ArrayList theirLocks = new ArrayList();
        String cursor = null;
        do {
            String cursorFinal = cursor;
            res = this.doWork(arg_0 -> Client.verifyLocks$lambda$11(this, cursorFinal, ref, arg_0), Operation.Upload);
            ourLocks.addAll(res.getOurs());
            theirLocks.addAll(res.getTheirs());
        } while ((cursor = res.getNextCursor()) != null && ((CharSequence)cursor).length() > 0);
        return new VerifyLocksResult((List)ourLocks, (List)theirLocks);
    }

    @Override
    public void close() throws IOException {
        this.http.close();
    }

    private static final ObjectRes getMeta$lambda$0(Client this$0, String $hash, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"objects/", $hash};
        return (ObjectRes)this$0.doRequest(auth, new MetaGet(), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final boolean putObject$lambda$1(Client this$0, Meta $meta, StreamProvider $streamProvider, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)$streamProvider, (String)"$streamProvider");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"objects"};
        ObjectRes links = (ObjectRes)this$0.doRequest(auth, new MetaPost($meta), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
        return links != null && this$0.putObject($streamProvider, $meta, (Links)links);
    }

    private static final ObjectRes postMeta$lambda$2(Client this$0, Meta $meta, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"objects"};
        return (ObjectRes)this$0.doRequest(auth, new MetaPost($meta), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final BatchRes postBatch$lambda$3(Client this$0, BatchReq $batchReq, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$batchReq, (String)"$batchReq");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"objects/batch"};
        return (BatchRes)this$0.doRequest(auth, (Request)new JsonPost<BatchReq, BatchRes>($batchReq, BatchRes.class), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final Object getObject$lambda$4(Client this$0, String $hash, StreamHandler $handler, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        ObjectRes links = this$0.getLinks($hash, auth);
        return this$0.getObject(links.getMeta() == null ? new Meta($hash, -1L) : links.getMeta(), (Links)links, $handler);
    }

    private static final Object getObject$lambda$5(StreamHandler $handler, Meta $meta, InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return $handler.accept($meta == null ? inputStream : (InputStream)new InputStreamValidator(inputStream, $meta));
    }

    private static final InputStream openObject$lambda$6(Client this$0, String $hash, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        ObjectRes links = this$0.getLinks($hash, auth);
        return this$0.openObject(links.getMeta() == null ? new Meta($hash, -1L) : links.getMeta(), (Links)links);
    }

    private static final InputStream openObject$lambda$7(Meta $meta, InputStream inputStream) {
        InputStream inputStream2;
        if ($meta == null) {
            inputStream2 = inputStream;
        } else {
            InputStream inputStream3 = inputStream;
            Intrinsics.checkNotNull((Object)inputStream3);
            inputStream2 = (InputStream)new InputStreamValidator(inputStream3, $meta);
        }
        Intrinsics.checkNotNull((Object)inputStream2);
        return inputStream2;
    }

    private static final LockCreate.Res lock$lambda$8(Client this$0, String $path, Ref $ref, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"locks"};
        return (LockCreate.Res)this$0.doRequest(auth, new LockCreate($path, $ref), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final Lock unlock$lambda$9(Client this$0, boolean $force, Ref $ref, String $lockId, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lockId, (String)"$lockId");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"locks/", $lockId + "/unlock"};
        return (Lock)this$0.doRequest(auth, new LockDelete($force, $ref), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final LocksRes listLocks$lambda$10(Client this$0, StringBuffer $params, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"locks" + $params};
        return (LocksRes)this$0.doRequest(auth, new LocksList(), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    private static final VerifyLocksRes verifyLocks$lambda$11(Client this$0, String $cursorFinal, Ref $ref, Link auth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String[] stringArray = new String[]{"locks/verify"};
        return (VerifyLocksRes)this$0.doRequest(auth, (Request)new JsonPost<VerifyLocksReq, VerifyLocksRes>(new VerifyLocksReq($cursorFinal, $ref, null), VerifyLocksRes.class), AuthHelper.INSTANCE.join(auth.getHref(), stringArray), ConnectionClosePolicy.Close);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lru/bozaro/gitlfs/client/Client$ConnectionClosePolicy;", "", "(Ljava/lang/String;I)V", "Close", "DoNotClose", "gitlfs-client"})
    public static final class ConnectionClosePolicy
    extends Enum<ConnectionClosePolicy> {
        public static final /* enum */ ConnectionClosePolicy Close = new ConnectionClosePolicy();
        public static final /* enum */ ConnectionClosePolicy DoNotClose = new ConnectionClosePolicy();
        private static final /* synthetic */ ConnectionClosePolicy[] $VALUES;

        public static ConnectionClosePolicy[] values() {
            return (ConnectionClosePolicy[])$VALUES.clone();
        }

        public static ConnectionClosePolicy valueOf(String value) {
            return Enum.valueOf(ConnectionClosePolicy.class, value);
        }

        static {
            $VALUES = connectionClosePolicyArray = new ConnectionClosePolicy[]{ConnectionClosePolicy.Close, ConnectionClosePolicy.DoNotClose};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/bozaro/gitlfs/client/Client$Companion;", "", "()V", "MAX_AUTH_COUNT", "", "MAX_REDIRECT_COUNT", "MAX_RETRY_COUNT", "appendOptionalParam", "", "buffer", "Ljava/lang/StringBuffer;", "paramName", "", "paramValue", "generateMeta", "Lru/bozaro/gitlfs/common/data/Meta;", "streamProvider", "Lru/bozaro/gitlfs/client/io/StreamProvider;", "sha256", "Ljava/security/MessageDigest;", "gitlfs-client"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Meta generateMeta(@NotNull StreamProvider streamProvider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
            MessageDigest digest = this.sha256();
            byte[] buffer = new byte[65536];
            long size = 0L;
            Object object = streamProvider.getStream();
            Throwable throwable = null;
            try {
                int read;
                InputStream stream = (InputStream)object;
                boolean bl = false;
                while ((read = stream.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                    size += (long)read;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            char[] cArray = Hex.encodeHex((byte[])digest.digest());
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"encodeHex(digest.digest())");
            object = cArray;
            return new Meta(new String((char[])object), size);
        }

        private final MessageDigest sha256() {
            MessageDigest messageDigest;
            try {
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-256");
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"{\n                Messag\u2026(\"SHA-256\")\n            }");
                messageDigest = messageDigest2;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            return messageDigest;
        }

        private final void appendOptionalParam(StringBuffer buffer, String paramName, String paramValue) throws UnsupportedEncodingException {
            if (paramValue != null) {
                buffer.append(((CharSequence)buffer).length() == 0 ? (char)'?' : '&').append(paramName).append('=').append(URLEncoder.encode(paramValue, "UTF-8"));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

