/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder.file;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;

class MdlFileContentProvider
implements ISimulinkFileContentProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String fileContent;
    private static final Pattern ENCODING_GUESS_PATTERN = Pattern.compile("SavedCharacterEncoding\\s+\"(.*?)\"");

    public MdlFileContentProvider(byte[] content, String utf8Content, ModelBuildingParameters parameters) {
        Charset charset = this.determineMdlCharset(utf8Content, parameters);
        this.fileContent = charset.equals(Charsets.UTF_8) ? utf8Content : new String(content, charset);
    }

    private Charset determineMdlCharset(String utf8Content, ModelBuildingParameters parameters) {
        if (!parameters.isGuessMdlEncoding()) {
            return parameters.getCharset();
        }
        Matcher matcher = ENCODING_GUESS_PATTERN.matcher(utf8Content);
        if (!matcher.find()) {
            return parameters.getCharset();
        }
        try {
            return Charset.forName(matcher.group(1));
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.error("Charset found in MDL file (" + matcher.group(1) + ") not supported by this installation. Falling back to " + parameters.getCharset().name());
            return parameters.getCharset();
        }
    }

    @Override
    public boolean isMultiFileContainer() {
        return false;
    }

    @Override
    public String getMainContent() {
        return this.fileContent;
    }

    @Override
    public List<String> listContainedFilenames() {
        return Collections.emptyList();
    }

    @Override
    public Optional<String> getNamedContent(String name) {
        return Optional.empty();
    }

    @Override
    public Optional<byte[]> getNamedBinaryContent(String name) {
        return Optional.empty();
    }
}

