/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public abstract class SimulinkResolvedInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PORT_SEPARATOR = ":";
    @JsonProperty
    protected final Map<String, String> resolvedInformation = new HashMap<String, String>();

    public static String getKey(SimulinkBlock block) {
        if (block instanceof SimulinkModel) {
            return ((SimulinkModel)block).getUniformPath();
        }
        return block.getParameter("SID");
    }

    public static String getKey(SimulinkBlock block, String portNumber) {
        if (portNumber == null || portNumber.isEmpty()) {
            return SimulinkResolvedInformation.getKey(block);
        }
        return SimulinkResolvedInformation.getKey(block) + PORT_SEPARATOR + portNumber;
    }

    @VisibleForTesting
    public Map<String, String> getResolvedInformation() {
        return this.resolvedInformation;
    }

    public boolean contains(SimulinkBlock block) {
        String key = SimulinkResolvedInformation.getKey(block);
        return this.resolvedInformation.containsKey(key);
    }

    public boolean contains(SimulinkBlock block, String index) {
        String key = block.getOutPorts().size() <= 1 ? SimulinkResolvedInformation.getKey(block) : SimulinkResolvedInformation.getKey(block, index);
        return this.resolvedInformation.containsKey(key);
    }

    public void setOutputInformationForBlock(SimulinkBlock block, String information) {
        LOGGER.debug("information of block " + SimulinkResolvedInformation.getKey(block) + " of model " + block.getModel().getName() + " is set to " + information);
        if (block.getOutPorts().size() <= 1) {
            String key = SimulinkResolvedInformation.getKey(block);
            this.resolvedInformation.put(key, information);
        } else {
            for (SimulinkOutPort outPort : block.getOutPorts()) {
                String key = SimulinkResolvedInformation.getKey(block, outPort.getIndex());
                this.resolvedInformation.put(key, information);
            }
        }
    }

    public void setOutputInformationForBlock(SimulinkBlock block, String portIndex, String information) {
        LOGGER.debug("information of block " + SimulinkResolvedInformation.getKey(block, portIndex) + " of model " + block.getModel().getName() + " is set to " + information);
        String key = block.getOutPorts().size() > 1 ? SimulinkResolvedInformation.getKey(block, portIndex) : SimulinkResolvedInformation.getKey(block);
        this.resolvedInformation.put(key, information);
    }

    public @Nullable String getResolvedOutputInformationForBlock(SimulinkBlock block, String portIndex) {
        String key = block.getOutPorts().size() > 1 ? SimulinkResolvedInformation.getKey(block, portIndex) : SimulinkResolvedInformation.getKey(block);
        return this.resolvedInformation.get(key);
    }

    public Set<String> getResolvedInformationForAllOutports(SimulinkBlock block) {
        UnmodifiableCollection<SimulinkOutPort> outPorts = block.getOutPorts();
        HashSet<String> resolvedInformationList = new HashSet<String>();
        if (outPorts.size() <= 1) {
            String key = SimulinkResolvedInformation.getKey(block);
            String resolvedInformation = this.resolvedInformation.get(key);
            if (resolvedInformation != null) {
                resolvedInformationList.add(resolvedInformation);
            }
        } else {
            for (SimulinkOutPort outPort : outPorts) {
                String key = SimulinkResolvedInformation.getKey(block, outPort.getIndex());
                String signalLabel = this.resolvedInformation.get(key);
                if (signalLabel == null) continue;
                resolvedInformationList.add(signalLabel);
            }
        }
        return resolvedInformationList;
    }

    protected @Nullable String getInputInformation(SimulinkBlock block, String portNumber) {
        SimulinkOutPort outPort = SimulinkUtils.getConnectedOutPort(block.getInPort(portNumber));
        if (outPort == null) {
            return null;
        }
        SimulinkBlock predecessor = outPort.getBlock();
        return this.getResolvedOutputInformationForBlock(predecessor, outPort.getIndex());
    }

    public Set<String> getInputInformation(SimulinkBlock block) {
        return new HashSet<String>(this.getInputInformationAsList(block));
    }

    protected List<String> getInputInformationAsList(SimulinkBlock block) {
        ArrayList<String> inputTypes = new ArrayList<String>();
        for (SimulinkLine line : block.getInLines()) {
            String portIndex;
            SimulinkBlock predecessor;
            String inputType;
            SimulinkOutPort port = line.getSrcPort();
            if (port == null || (inputType = this.getResolvedOutputInformationForBlock(predecessor = port.getBlock(), portIndex = port.getIndex())) == null) continue;
            inputTypes.add(inputType);
        }
        return inputTypes;
    }

    protected Set<String> getInputInformation(SimulinkBlock block, Set<String> portNumbers) {
        return portNumbers.stream().map(portNumber -> this.getInputInformation(block, (String)portNumber)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulinkResolvedInformation that = (SimulinkResolvedInformation)o;
        return this.resolvedInformation.equals(that.resolvedInformation);
    }

    public int hashCode() {
        return this.resolvedInformation.hashCode();
    }
}

