/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.block_type_default_parameter_values;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.simulink.model.block_type_default_parameter_values.shared.SimulinkParameterDefaultValues;
import org.conqat.lib.simulink.util.SimulinkJsonUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkBlockDefaultParameterValueStorage {
    private static final ImmutableSet<String> SUPPORTED_MATLAB_RELEASES = ImmutableSet.of((Object)"R2022b", (Object)"R2023a", (Object)"R2023b", (Object)"R2024a", (Object)"R2024b");
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    protected static final String DELIMITER = "!==CQSE==!";
    private static final Map<String, Map<String, String>> DEFAULT_VALUES = new HashMap<String, Map<String, String>>();

    private static String buildDefaultValuesKey(String blockTypeName, String parameterName) {
        return blockTypeName + DELIMITER + parameterName;
    }

    public static boolean isDefaultParameterValuesAvailable(@Nullable String requestedMatlabRelease) {
        return SimulinkBlockDefaultParameterValueStorage.determineMatlabReleaseToUse(requestedMatlabRelease).isPresent();
    }

    @VisibleForTesting
    static Optional<String> determineMatlabReleaseToUse(@Nullable String requestedMatlabRelease) {
        Comparator comparator = Comparator.nullsFirst(Comparator.naturalOrder());
        return SUPPORTED_MATLAB_RELEASES.stream().filter(supportedRelease -> comparator.compare(supportedRelease, requestedMatlabRelease) <= 0).max(comparator);
    }

    public static @Nullable String getDefaultParameterValue(String blockTypeName, String parameterName, String matlabStorageVersion) {
        String storageVersion = SimulinkBlockDefaultParameterValueStorage.determineMatlabReleaseToUse(matlabStorageVersion).orElse(null);
        if (storageVersion == null) {
            return null;
        }
        Map<String, String> defaultValuesForRelease = SimulinkBlockDefaultParameterValueStorage.getDefaultValuesForMatlabRelease(matlabStorageVersion);
        if (defaultValuesForRelease == null) {
            return null;
        }
        return defaultValuesForRelease.get(SimulinkBlockDefaultParameterValueStorage.buildDefaultValuesKey(blockTypeName, parameterName));
    }

    private static Map<String, String> getDefaultValuesForMatlabRelease(String matlabRelease) {
        Map<String, String> defaultValuesForRelease = DEFAULT_VALUES.get(matlabRelease);
        if (defaultValuesForRelease != null) {
            return defaultValuesForRelease;
        }
        defaultValuesForRelease = new HashMap<String, String>();
        String resourcesPathForMatlabVersion = "exports/" + matlabRelease;
        Optional defaultValuesDirForStorageVersion = Resource.asOptional(SimulinkBlockDefaultParameterValueStorage.class, (String)resourcesPathForMatlabVersion);
        if (!defaultValuesDirForStorageVersion.isPresent()) {
            return null;
        }
        List exportFiles = ResourceUtils.listResources(SimulinkBlockDefaultParameterValueStorage.class, (String)resourcesPathForMatlabVersion);
        for (Resource exportFile : exportFiles) {
            try {
                SimulinkBlockDefaultParameterValueStorage.loadDefaultParameterValuesFromFile(defaultValuesForRelease, exportFile);
            }
            catch (ConQATException e) {
                LOGGER.error("Could not deserialize Simulink Block parameter default values from file " + exportFile.getPath(), (Throwable)e);
                return null;
            }
        }
        DEFAULT_VALUES.put(matlabRelease, defaultValuesForRelease);
        return defaultValuesForRelease;
    }

    @VisibleForTesting
    static void loadDefaultParameterValuesFromFile(Map<String, String> defaultValuesForRelease, Resource exportFile) throws ConQATException {
        SimulinkParameterDefaultValues json = SimulinkJsonUtils.deserializeFromJson(exportFile.getContent(), SimulinkParameterDefaultValues.class);
        for (Map.Entry<String, List<SimulinkParameterDefaultValues.DefaultParameterValue>> entry : json.parameterDefaultValues.entrySet()) {
            String blockTypeName = entry.getKey();
            for (SimulinkParameterDefaultValues.DefaultParameterValue parameter : entry.getValue()) {
                defaultValuesForRelease.put(SimulinkBlockDefaultParameterValueStorage.buildDefaultValuesKey(blockTypeName, parameter.parameterName), parameter.parameterValue);
            }
        }
    }
}

