/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Font;

public class FontData {
    private static final String NAME_PROPERTY = "name";
    private static final String SIZE_PROPERTY = "size";
    private static final String BOLD_PROPERTY = "bold";
    private static final String ITALIC_PROPERTY = "italic";
    private static Font overrideFont = null;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="size")
    private final int size;
    @JsonProperty(value="bold")
    private final boolean bold;
    @JsonProperty(value="italic")
    private final boolean italic;

    @JsonCreator
    public FontData(@JsonProperty(value="name") String name, @JsonProperty(value="size") int size, @JsonProperty(value="bold") boolean bold, @JsonProperty(value="italic") boolean italic) {
        this.name = name;
        this.size = size;
        this.bold = bold;
        this.italic = italic;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public Font getAwtFont() {
        if (overrideFont != null) {
            return overrideFont.deriveFont(0, this.size);
        }
        return new Font(this.name, this.getAwtFontStyle(), this.size);
    }

    public int getAwtFontStyle() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        }
        if (this.italic) {
            style |= 2;
        }
        return style;
    }

    public static void setOverrideFont(Font overrideFont) {
        FontData.overrideFont = overrideFont;
    }
}

