/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service;

import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterator;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class IteratorStreaming {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T> @NonNull StreamingOutput createJsonStreamFromStorageIterator(StorageIterator<T, StorageException> resultsIterator) {
        return output -> {
            try {
                output.write("[\n".getBytes(StandardCharsets.UTF_8));
                while (resultsIterator.hasNext()) {
                    Object element = resultsIterator.next();
                    JsonUtils.getObjectMapper().writer().writeValue(output, element);
                    if (resultsIterator.hasNext()) {
                        output.write(",".getBytes(StandardCharsets.UTF_8));
                    }
                    output.write("\n".getBytes(StandardCharsets.UTF_8));
                }
                output.write("]\n".getBytes(StandardCharsets.UTF_8));
            }
            catch (StorageException e) {
                LOGGER.error("Streaming to JSON failed.", (Throwable)e);
                output.close();
            }
        };
    }

    public static <T, E extends Exception> StreamingOutput createCsvStreamFromStorageIterator(@Nullable String[] headers, Function<T, String[]> toRowFunction, StorageIterator<T, E> resultsIterator) {
        return output -> {
            CsvPreference preference = new CsvPreference.Builder(CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE).build();
            try (CsvListWriter writer = new CsvListWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), preference);){
                if (headers != null) {
                    writer.writeHeader(headers);
                }
                while (resultsIterator.hasNext()) {
                    String[] row = (String[])toRowFunction.apply(resultsIterator.next());
                    writer.write(row);
                }
            }
            catch (Exception e) {
                LOGGER.error("Streaming to CSV failed.", (Throwable)e);
                output.close();
            }
        };
    }
}

