/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.google.common.base.Preconditions;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.write.BackupExportOptions;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupExportStatusIndex;
import com.teamscale.service.admin.backup.BackupStatusServiceBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class BackupExportJobService
extends BackupStatusServiceBase<BackupExportStatus> {
    public BackupExportJobService(String backupId) {
        super(backupId);
    }

    @Override
    @Operation(summary="Get the backup export status", description="Get the current backup export status", tags={"Backup"}, responses={@ApiResponse(responseCode="404", description="No backup for the provided ID found.")}, operationId="getBackupExportStatus")
    public BackupExportStatus getBackupStatus() throws StorageException {
        return (BackupExportStatus)super.getBackupStatus();
    }

    @Override
    protected BackupExportStatus getStatusSummary(String key) throws StorageException {
        return this.openGlobalIndex(BackupExportStatusIndex.class).getStatus(key);
    }

    @GET
    @Path(value="download")
    @Operation(summary="Download backup", description="Allows downloading a Teamscale backup from the temporary file store.", tags={"Backup"}, responses={@ApiResponse(responseCode="400", description="The backup is not ready for download as it is still running or failed."), @ApiResponse(responseCode="403", description="The user is authenticated, but does not have the necessary permissions to access the endpoint."), @ApiResponse(responseCode="404", description="The backup was not found.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_1_0)
    @RequiresNoPermission(description="The user needs to have the permission to backup global data provided it is contained in the backup and the permission to backup project data for all projects contained in the backup.")
    @Produces(value={"application/zip"})
    public Response downloadBackup() throws StorageException {
        TemporaryFileIndex fileIndex = this.openGlobalIndex(TemporaryFileIndex.class);
        if (!fileIndex.fileExists(this.backupId)) {
            throw new NotFoundException("Unknown backup ID: " + this.backupId);
        }
        BackupExportStatusIndex exportStatusIndex = this.openGlobalIndex(BackupExportStatusIndex.class);
        BackupExportStatus exportStatus = exportStatusIndex.getStatus(this.backupId);
        if (exportStatus == null) {
            throw new NotFoundException(String.format("Backup \"%s\" does not exist", this.backupId));
        }
        BackupExportOptions exportOptions = exportStatus.getBackupExportOptions();
        this.getPermissions().checkBackupPermissions(exportOptions.isExportGlobalData(), exportOptions.getAllIncludedProjects());
        if (exportStatus.getStatus() == EBackupStatus.IN_PROGRESS) {
            throw new BadRequestException("The backup is still in progress!");
        }
        if (exportStatus.getStatus() == EBackupStatus.FAILURE) {
            throw new BadRequestException("Backup creation failed!");
        }
        Preconditions.checkState((exportStatus.getStatus() == EBackupStatus.SUCCESS ? 1 : 0) != 0);
        StreamingOutput streamingOutput = output -> {
            try (InputStream in = fileIndex.readFile(this.backupId);){
                FileSystemUtils.copy((InputStream)in, (OutputStream)output);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        };
        long fileSize = ((TemporaryFileIndex.TemporaryFileDescriptor)fileIndex.getFileDescriptor(this.backupId).orElseThrow(() -> new NotFoundException("Backup \"%s\" file does not exist".formatted(this.backupId)))).exactSizeInBytes();
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)(this.backupId + ".zip"), (long)fileSize);
    }
}

