/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.audit.LicenseTreeMapBuilder;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/copyright-licenses/treemap")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
public class LicenseTreeMapService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get copyright license treemap", description="Builds a treemap of the copyright licenses in a system.", tags={"Audit"})
    public FilteredTreeMapWrapper getCopyrightLicensesTreemap(@Parameter(description="Uniform path to retrieve licenses for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam TreemapQueryOptions requestOptions, @Parameter(description="The list of customer licenses that should be compared against. Comparison is case sensitive. Licenses are separated by commas.") @QueryParam(value="customer-license") Set<String> customerLicenses, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, TreeMapBuilderException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        CopyrightLicenseIndex licenseIndex = this.openProjectIndex(CopyrightLicenseIndex.class, historyAccessOption);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        LicenseTreeMapBuilder licenseTreeMapBuilder = new LicenseTreeMapBuilder(requestOptions.includePattern, requestOptions.excludePattern, metricRetrievalStrategy, historyAccessOption, requestOptions.areaMetricIndex, requestOptions.colorMetricIndex, requestOptions.colorMetricDefaultValue, requestOptions.baseColor, customerLicenses, licenseIndex);
        return licenseTreeMapBuilder.getWrapper(uniformPath);
    }
}

