/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.audit.ThirdPartyDependencyExtractor;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class TechnologyTreeMapBuilder
extends MetricTreemapBuilderBase<TreeMapNode> {
    private final boolean isColorGradationActive;
    private FilteredTreeMapWrapper treemapWrapper;
    private double colorMetricMaxValue;
    private TreeMapNode treemap;
    private final ThirdPartyDependencyExtractor dependencyExtractor;

    protected TechnologyTreeMapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, int colorMetricIndex, Object colorMetricDefault, Color baseColor, ThirdPartyDependencyExtractor dependencyExtractor, boolean isColorGradationActive) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, new MetricTreemapBuilderParameters(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor));
        this.dependencyExtractor = dependencyExtractor;
        this.isColorGradationActive = isColorGradationActive;
    }

    protected FilteredTreeMapWrapper getWrapper(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        this.treemap = this.buildTreeMap(uniformPath);
        this.treemapWrapper.setTreemap(this.treemap);
        return this.treemapWrapper;
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        String uniformPath = entry.getUniformPath();
        String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)uniformPath);
        Set<String> dependencies = this.dependencyExtractor.retrieveDependencies(cleanPath);
        return new TreeMapNode(uniformPath, entry.getDoubleValue(this.areaMetricIndex), TechnologyTreeMapBuilder.getDependencyNames(dependencies), this.getDependencyColor(dependencies));
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
        this.colorMetricMaxValue = 0.0;
        int filesIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Files");
        int overallFiles = (int)entries.get(0).getDoubleValue(filesIndex);
        int affectedFiles = 0;
        int affectedLoc = 0;
        int overallHits = 0;
        ArrayList<String> affectedPaths = new ArrayList<String>();
        for (MetricDirectoryEntry entry : entries) {
            String uniformPath = entry.getUniformPath();
            String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)uniformPath);
            Set<String> dependencies = this.dependencyExtractor.retrieveDependencies(cleanPath);
            if (!dependencies.isEmpty()) {
                ++affectedFiles;
                affectedLoc += (int)entry.getDoubleValue(this.areaMetricIndex);
                overallHits += dependencies.size();
                affectedPaths.add(entry.getUniformPath());
            }
            this.colorMetricMaxValue = Math.max((double)dependencies.size(), this.colorMetricMaxValue);
        }
        this.treemapWrapper = new FilteredTreeMapWrapper(affectedPaths, this.treemap, overallFiles, affectedLoc, affectedFiles, overallHits);
    }

    private static String getDependencyNames(Set<String> dependencies) {
        return StringUtils.concat(dependencies, (String)",\n");
    }

    @Override
    protected Pair<Double, Double> determineValueRangeForColorMetric(List<MetricDirectoryEntry> entries) {
        return new Pair((Object)0.0, (Object)this.colorMetricMaxValue);
    }

    private Color getDependencyColor(Set<String> dependencies) {
        if (dependencies.isEmpty()) {
            return Color.WHITE;
        }
        if (this.isColorGradationActive) {
            return this.determineColorForNumber(dependencies.size());
        }
        return Color.BLUE;
    }
}

