/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.index.OAuthTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/github/oauth")
public class GitHubAuthenticationService
extends SsoAuthenticationServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Handles the redirection of the GitHub OAuth authentication.", description="Redirects the user to the target that has been passed in the state parameter or dashboard if it does not exist.", tags={"Voting Connectors"})
    @RequiresNoLogin
    public Response authenticate(@Parameter(description="The authentication code from GitHub.", required=true) @QueryParam(value="code") String code, @Parameter(description="The state that was passed to GitHub.") @QueryParam(value="state") String state) throws StorageException, AuthenticationToolException {
        GitHubApplicationDescription.State parsedState = this.parseState(state);
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        GitHubApplicationDescription description = GitHubAppUtils.loadConfiguredApplication((String)parsedState.appId(), (String)parsedState.serverUrl(), (ServerOptionIndex)optionIndex, InternalServerErrorException::new);
        OAuthTokenIndex oAuthTokenIndex = this.openGlobalIndex(OAuthTokenIndex.class);
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        UserGroupIndex userGroupIndex = this.openGlobalIndex(UserGroupIndex.class);
        try {
            String accessToken = GitHubAuthenticationService.requestAccessToken(code, description);
            Optional userOptional = GitHubAuthenticationUtils.getOrCreateAuthenticatedUser((String)accessToken, (String)description.serverUrl, (GitHubApplicationDescription)description, (UserIndex)userIndex, (UserGroupIndex)userGroupIndex, (OAuthTokenIndex)oAuthTokenIndex, (IMessageBroker)this.serviceInfo.getMessageBroker());
            if (userOptional.isEmpty() || !((User)userOptional.get()).getAuthenticator().startsWith("GitHubOAuth")) {
                throw new RedirectionException("Failed to login via GitHub. GitHub user does not exist as Teamscale User.", 302, this.buildErrorURI("GithubNoSuchTeamscaleUser"));
            }
            User user = (User)userOptional.get();
            return this.buildSsoResponse(user, parsedState.redirectionTarget());
        }
        catch (ServiceCallException e) {
            throw new RedirectionException("Failed to login via Github. Secret ID of GitHub App is incorrect.", 302, this.buildErrorURI("GithubOAuthSecret"));
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private GitHubApplicationDescription.State parseState(String state) {
        try {
            return GitHubApplicationDescription.State.fromQueryString((String)state);
        }
        catch (ConQATException e) {
            LOGGER.error("Failed to deserialize state from: {}", (Object)state, (Object)e);
            throw new RedirectionException("Failed to login via GitHub. Provided state did not have the desired format.", 302, this.buildErrorURI("GitHubState"));
        }
    }

    private static String requestAccessToken(String code, GitHubApplicationDescription description) throws ServiceCallException {
        return GitHubAuthenticationUtils.requestAccessToken((String)code, (GitHubApplicationDescription)description);
    }
}

