/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge.velocity;

import com.teamscale.service.framework.badge.SvgUtils;

public class Segment {
    private final String text;
    private final String tooltip;
    private final String color;
    private final double segmentStart;
    private final double segmentWidth;
    private static final double MARGIN = 5.0;

    public Segment(String tooltip, String color, double segmentStart, double segmentWidth) {
        this.text = "";
        this.color = color;
        this.tooltip = tooltip;
        this.segmentStart = segmentStart;
        this.segmentWidth = segmentWidth;
    }

    public Segment(String text, String tooltip, String color, double segmentStart) {
        this.text = text;
        this.color = color;
        this.tooltip = tooltip;
        this.segmentStart = segmentStart;
        this.segmentWidth = (double)SvgUtils.computeTextWidth((String)text) + 2.0 * Segment.getMargin();
    }

    public Segment(String text, String tooltip, String color, double segmentStart, double segmentWidth) {
        this.text = text;
        this.color = color;
        this.tooltip = tooltip;
        this.segmentStart = segmentStart;
        this.segmentWidth = segmentWidth;
    }

    public String getText() {
        return this.text;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public double getSegmentStart() {
        return this.segmentStart;
    }

    public double getSegmentWidth() {
        return this.segmentWidth;
    }

    public String getColor() {
        return this.color;
    }

    public static double getMargin() {
        return 5.0;
    }
}

