/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.service.commits.ECommitAttribute;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class RepositoryLogFilterBase {
    public static final String COMMIT_TYPES = "commit-types";
    private static final String COMMIT_ATTRIBUTE = "commit-attribute";
    private static final String EXCLUDE_OTHER_BRANCHES = "exclude-other-branches";
    @Parameter(description="The commit types to show or hide. If omitted, commits for all types are returned.")
    @QueryParam(value="commit-types")
    protected Set<ECommitType> commitTypes;
    @Parameter(description="The commit attribute to filter by.")
    @QueryParam(value="commit-attribute")
    @DefaultValue(value="IS_ANY_COMMIT")
    protected ECommitAttribute commitAttribute;
    @Parameter(description="Option whether to filter out commits, that belong to other branches.")
    @QueryParam(value="exclude-other-branches")
    protected boolean excludeOtherBranches;
    @Hidden
    protected String filteringBranchName;

    public RepositoryLogFilterBase(Set<ECommitType> commitTypes, ECommitAttribute commitAttribute, boolean excludeOtherBranches, String filteringBranchName) {
        this.commitTypes = commitTypes;
        this.commitAttribute = commitAttribute;
        this.excludeOtherBranches = excludeOtherBranches;
        this.filteringBranchName = filteringBranchName;
    }

    public RepositoryLogFilterBase() {
    }

    protected <T extends IRepositoryLogEntry> void removeCommitsFromUnmatchedTypes(Collection<T> relevantEntries) {
        relevantEntries.removeIf(logEntry -> logEntry != null && CollectionUtils.intersectionSet(this.commitTypes, (Collection[])new Collection[]{logEntry.getCommitTypes()}).isEmpty());
    }

    protected <T extends IRepositoryLogEntry> void excludeCommitsOfOtherBranches(Collection<T> logEntries) {
        if (!this.excludeOtherBranches) {
            return;
        }
        logEntries.removeIf(logEntry -> !logEntry.getCommit().getBranchName().equals(this.filteringBranchName));
    }
}

