/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.dashboard.widgets.CodeCityNode;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.dashboard.widgets.CodeCityBuilder;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.TreemapServiceBase;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code-city")
public class CodeCitiesService
extends TreemapServiceBase {
    @GET
    @Operation(summary="Get code city", description="Builds a code city for the given path.", tags={"Dashboards", "Treemap"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public CodeCityNode getCodeCities(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to build a code city for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam TreemapQueryOptions treemapParameters, @QueryParam(value="height-metric") @Parameter(description="The index for the metric used to determine the height of the displayed nodes.") int heightMetricIndex) throws StorageException, TreeMapBuilderException {
        this.adjustTreemapQueryOptions(treemapParameters, uniformPath.getType());
        return this.computeRootTreemapNode(treemapParameters, heightMetricIndex, uniformPath, this.determineHistoryOption(commit));
    }

    private CodeCityNode computeRootTreemapNode(TreemapQueryOptions treemapParameters, int heightMetricIndex, UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException, TreeMapBuilderException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        CodeCityBuilder codeCityBuilder = new CodeCityBuilder(treemapParameters.includePattern, treemapParameters.excludePattern, metricRetrievalStrategy, historyAccessOption, treemapParameters.areaMetricIndex, treemapParameters.colorMetricIndex, heightMetricIndex, treemapParameters.colorMetricDefaultValue, treemapParameters.baseColor, treemapParameters.isColorBlindModeEnabled());
        return (CodeCityNode)codeCityBuilder.buildTreeMap(uniformPath);
    }
}

