/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.metrics.schema.MetricSchemaService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/dashboards/widget-context")
public class WidgetContextService
extends ApiBase {
    @GET
    @Operation(summary="Returns all accessible projects along with their metric schema", tags={"Dashboards"})
    @RequiresNoPermission(description="The permissions will be checked at runtime (this service works cross-project)")
    public WidgetContext getWidgetContext() throws StorageException {
        WidgetContext context = new WidgetContext();
        List projectIds = ProjectUtils.resolveToPrimaryPublicId((List)this.getPermissions().getVisibleProjects());
        for (PublicProjectId projectId : projectIds) {
            context.schemasByProjectId.put(projectId.toString(), MetricSchemaService.getSchema(UniformPath.EType.CODE, this.getProjectStorageSystem((IProjectId)projectId), this.getGlobalStorageSystem(), this.getUser()));
        }
        return context;
    }

    private static class WidgetContext {
        private static final String SCHEMAS_BY_PROJECT_ID_PROPERTY = "schemasByProjectId";
        @JsonProperty(value="schemasByProjectId")
        private final Map<String, MetricDirectorySchema> schemasByProjectId = new HashMap<String, MetricDirectorySchema>();

        private WidgetContext() {
        }
    }
}

