/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.service.external.input.ReviewFindingServiceBase;
import com.teamscale.service.external.input.ReviewFindingServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/review-findings/{findingId}/resolution")
public class ReviewFindingResolutionService
extends ReviewFindingServiceBase<ReviewFindingServiceQueryOptions> {
    @POST
    @Operation(summary="Resolve code review finding", description="Mark the provided code review finding as resolved.", tags={"Findings"}, responses={@ApiResponse(responseCode="404", description="Finding with given ID not found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void resolveReviewFinding(@Parameter(description="ID of the resolved finding") @PathParam(value="findingId") String findingId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        this.logManager.logParameter("id", findingId);
        ReviewFindingServiceQueryOptions parameters = new ReviewFindingServiceQueryOptions(commit, findingId, "Code Review Finding Resolution by " + this.serviceInfo.getUser().getFullName());
        this.process(EHttpMethod.POST, null, parameters, "auto-create");
    }

    @Override
    protected ExternalAnalysisImportInfoFindings createAnalysisImportInfoFindings(TrackedFinding trackedFinding, ReviewFindingServiceQueryOptions parameters) {
        return new ExternalAnalysisImportInfoFindings(trackedFinding.getLocation().getUniformPath(), Collections.emptyList(), List.of(new DetachedFinding((DetachedFinding)trackedFinding)));
    }
}

