/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.POST;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;

public interface IFindingTypeDescriptorService {
    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_5_0, deprecatedSince=ETeamscaleVersion.VERSION_2025_5_0)
    @Operation(summary="Get finding descriptions", description="Returns user readable finding names and descriptions for given finding type IDs.\nIf the project uses multiple code scopes, the values of the default code scope take precedence.\nIf values are registered for multiple other code-scopes (and none for the default code scope), the value is randomly chosen from one of the other code-scopes.\n")
    public List<FindingTypeDescription> getFindingTypeDescriptions(@RequestBody(required=true) List<String> var1) throws StorageException;

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_5_0)
    @Operation(summary="Get finding descriptions", description="Returns user readable finding names and descriptions for given finding type IDs per code scope")
    public Map<CodeScopeName, Map<String, FindingTypeDescription>> getFindingTypeDescriptions(@RequestBody(required=true) Map<CodeScopeName, Set<String>> var1) throws StorageException;
}

