/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.findings.FindingsBlacklistServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/findings/unmark-before-commit")
public class UnmarkToleratedAndFalsePositiveFindingsBeforeCommitService
extends FindingsBlacklistServiceBase {
    private static final String UNMARK_FALSE_POSITIVES_PARAMETER_DESCRIPTION = "Whether false positive findings should be unmarked as well. If not specified, only tolerated findings will be unmarked.";
    public static final String UNMARK_FALSE_POSITIVES_PARAMETER_NAME = "unmark-false-positives";

    @DELETE
    @RequiresProjectPermission(value={EProjectPermission.VIEW, EProjectPermission.EXCLUDE_RED_FINDINGS, EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION, EProjectPermission.EXCLUDE_YELLOW_FINDINGS, EProjectPermission.APPROVE_YELLOW_FINDINGS_EXCLUSION})
    @Operation(summary="Unmark tolerated/false positive findings before given commit.", description="Unmark all tolerated/false positive findings that were marked before the given commit. Also returns the ids of the unmarked findings.", responses={@ApiResponse(responseCode="400", description="Operation is performed on unknown branch."), @ApiResponse(responseCode="404", description="Requested finding does not exist.")}, tags={"Findings"})
    public List<String> unmarkToleratedAndFalsePositiveFindingsBeforeCommit(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Whether false positive findings should be unmarked as well. If not specified, only tolerated findings will be unmarked.") @QueryParam(value="unmark-false-positives") boolean isUnmarkFalsePositives) throws StorageException, NotFoundException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption);
        ArrayList<String> toleratedFindingIds = new ArrayList<String>();
        ArrayList<String> falsePositiveFindingIds = new ArrayList<String>();
        for (FindingBlacklistInfo blacklistInfo : blacklistIndex.getAllBlacklistInfos().values()) {
            if (isUnmarkFalsePositives && blacklistInfo.getType() == EFindingBlacklistType.FALSE_POSITIVE) {
                falsePositiveFindingIds.add(blacklistInfo.getFindingId());
                continue;
            }
            if (blacklistInfo.getType() != EFindingBlacklistType.TOLERATION) continue;
            toleratedFindingIds.add(blacklistInfo.getFindingId());
        }
        TrackedFindingsByIdIndex trackedFindingsByIdIndex = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        List toleratedFindings = trackedFindingsByIdIndex.getFindings(toleratedFindingIds);
        PairList findingIdsToFindings = PairList.zip(toleratedFindingIds, (List)toleratedFindings);
        this.removeFindingsFromBlacklist((PairList<String, TrackedFinding>)findingIdsToFindings, blacklistIndex, EFindingBlacklistType.TOLERATION, historyAccessOption.getBranchName());
        List falsePositiveFindings = trackedFindingsByIdIndex.getFindings(falsePositiveFindingIds);
        findingIdsToFindings = PairList.zip(falsePositiveFindingIds, (List)falsePositiveFindings);
        this.removeFindingsFromBlacklist((PairList<String, TrackedFinding>)findingIdsToFindings, blacklistIndex, EFindingBlacklistType.FALSE_POSITIVE, historyAccessOption.getBranchName());
        return Stream.concat(toleratedFindingIds.stream(), falsePositiveFindingIds.stream()).toList();
    }
}

