/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.clangtidy;

import com.google.common.hash.HashCode;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisHashUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.EClangTidyOutsourcedAnalysisStatus;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContext;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContextIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisFindingsCacheIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisRunner;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Path(value="api/analysis/clangtidy-execution")
public class ClangTidyAnalysisExecutionService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Request a ClangTidy analysis", description="Opens and schedules a new ClangTidy analysis session, returning the session key.", tags={"External Analysis"})
    public String requestAnalysisAndOpenSession(@QueryParam(value="projectId") @Nullable IProjectId projectId, @QueryParam(value="commitDescriptor") @Nullable UnresolvedCommitDescriptor commit, @QueryParam(value="returnAddress") @Nullable String returnAddress, @RequestBody(required=true) ClangTidyOutsourcedAnalysisRequestParameters parameters) throws StorageException, IOException, ServiceCallException {
        LOGGER.debug("Received request for ClangTidy analysis on {} file(s).", new Supplier[]{() -> parameters.analysisSubjectInfos().size()});
        if (projectId == null || commit == null || returnAddress == null) {
            throw new ServiceCallException(String.format("If one of project ID, commit or return address is provided, all of them are required. Provided project ID '%s', commit '%s' and return address '%s'.", projectId, commit, returnAddress));
        }
        String sessionKey = this.generateSessionKey(projectId, commit, parameters);
        this.scheduleAnalysisTrigger(projectId, commit, returnAddress, parameters, sessionKey);
        return sessionKey;
    }

    @GET
    @Path(value="status")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Get the status of a ClangTidy Analysis session", description="Gets the status of the given session. May return the 'unknown' status, if no session was found for the given key.", tags={"External Analysis"})
    public EClangTidyOutsourcedAnalysisStatus getAnalysisStatus(@QueryParam(value="sessionKey") String sessionKey) throws StorageException, NotFoundException {
        Optional status = ((ClangTidyOutsourcedAnalysisStatusIndex)this.getIndexLayer().openGlobalIndex(ClangTidyOutsourcedAnalysisStatusIndex.class)).getStatus(sessionKey);
        if (status.isEmpty()) {
            LOGGER.debug("Received request to read status of session '{}'; Session is not found.", (Object)sessionKey);
            throw new NotFoundException("Session " + sessionKey + " is not found");
        }
        LOGGER.debug("Received request to read status of session '{}'; current status is {}.", (Object)sessionKey, (Object)((EClangTidyOutsourcedAnalysisStatus)status.get()).name());
        return (EClangTidyOutsourcedAnalysisStatus)status.get();
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Get ClangTidy analysis results", description="Gets the ClangTidy analysis results. Results may be incomplete if the session is not in the completed status.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session found with the given key.")})
    public List<ClangTidyResultsTransport> getAnalysisResultsByPath(@QueryParam(value="sessionKey") String sessionKey) throws StorageException {
        LOGGER.debug("Received request to read ClangTidy findings for session '{}'.", (Object)sessionKey);
        IndexLayer indexLayer = this.getIndexLayer();
        ClangTidyOutsourcedAnalysisContext context = (ClangTidyOutsourcedAnalysisContext)((ClangTidyOutsourcedAnalysisContextIndex)indexLayer.openGlobalIndex(ClangTidyOutsourcedAnalysisContextIndex.class)).getContext(sessionKey).orElseThrow(() -> new NotFoundException("No session found with key '" + sessionKey + "'."));
        Map fileAnalysisHashes = CollectionUtils.map((Map)ClangTidyOutsourcedAnalysisHashUtils.computeInputHashCodesForSubjectFiles((ClangTidyOutsourcedAnalysisRequestParameters)context.parameters()), Function.identity(), HashCode::toString);
        Map cachedResultsByHash = ((ClangTidyOutsourcedAnalysisFindingsCacheIndex)indexLayer.openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class)).readCache(fileAnalysisHashes.values());
        ArrayList<ClangTidyResultsTransport> resultsByUniformPath = new ArrayList<ClangTidyResultsTransport>();
        for (Map.Entry entry : fileAnalysisHashes.entrySet()) {
            String uniformPath = (String)entry.getKey();
            String inputHash = (String)entry.getValue();
            ClangTidyResultsTransport results = cachedResultsByHash.getOrDefault(inputHash, ClangTidyResultsTransport.emptyResult((String)uniformPath));
            resultsByUniformPath.add(results);
        }
        return resultsByUniformPath;
    }

    private String generateSessionKey(@Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit, ClangTidyOutsourcedAnalysisRequestParameters parameters) {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        if (projectId != null && commit != null) {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)projectId.toString());
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)commit.getBranchName());
            XXHashUtils.updateHash((StreamingXXHash64)hash, (byte[])ByteArrayUtils.longToByteArray((long)commit.getTimestamp()));
        } else {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)UUID.randomUUID().toString());
        }
        XXHashUtils.updateHash((StreamingXXHash64)hash, (String)String.valueOf(parameters.hashCode()));
        return String.valueOf(hash.getValue());
    }

    private void scheduleAnalysisTrigger(@Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit, @Nullable String returnAddress, ClangTidyOutsourcedAnalysisRequestParameters parameters, String sessionKey) throws StorageException {
        ClangTidyOutsourcedAnalysisStatusIndex statusIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisStatusIndex.class);
        Optional currentSessionStatus = statusIndex.getStatus(sessionKey);
        if (currentSessionStatus.isPresent() && currentSessionStatus.get() != EClangTidyOutsourcedAnalysisStatus.ERROR) {
            return;
        }
        try {
            ClangTidyOutsourcedAnalysisContext context = new ClangTidyOutsourcedAnalysisContext(returnAddress, projectId, commit, parameters);
            this.openGlobalIndex(ClangTidyOutsourcedAnalysisContextIndex.class).storeContext(sessionKey, context);
            ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(ClangTidyOutsourcedAnalysisRunner.class, sessionKey, "Scheduled due to external ClangTidy analysis request session " + sessionKey + ".", this.getIndexLayer());
            statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.SCHEDULED);
        }
        catch (Throwable t) {
            statusIndex.setStatus(sessionKey, EClangTidyOutsourcedAnalysisStatus.ERROR);
            throw t;
        }
    }

    @DELETE
    @Path(value="clearResultsCache")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Clear analysis results cached on this Execution Server for a given project", description="The execution server caches analysis results and serves them if the same analysis request comes again. This DELETE request clears that cache of analysis results.", tags={"External Analysis"})
    public void clearResultsCache() throws StorageException {
        ((ClangTidyOutsourcedAnalysisFindingsCacheIndex)this.getIndexLayer().openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class)).clear();
        ((ClangTidyOutsourcedAnalysisStatusIndex)this.getIndexLayer().openGlobalIndex(ClangTidyOutsourcedAnalysisStatusIndex.class)).clear();
    }
}

