/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.findings.FindingsIntroductionRemovalServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/findings/debug/list.csv")
public class DebugDetailedFindingsListService
extends FindingsIntroductionRemovalServiceBase {
    private static final String SEPARATOR = ";";
    private static final String[] HEADERS = new String[]{"id", "partition", "category", "group", "birth", "birth cause", "death", "death cause", "location", "message"};

    @GET
    @Produces(value={"text/csv"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Findings list", description="Returns a CSV for all findings in a project. This is potentially very slow and should only be used for testing/debugging purposes. One application is to find interesting findings for demos and case studies.", tags={"Findings", "Debugging"})
    public String getAsCsv(@QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.concat((Object[])HEADERS, (String)SEPARATOR)).append("\n");
        TrackedFindingsByIdIndex index = this.openProjectIndex(TrackedFindingsByIdIndex.class, this.determineHistoryOption(commit));
        for (TrackedFinding finding : index.getAllFindings()) {
            DebugDetailedFindingsListService.appendFinding(this.createFindingWithDiffInfo(finding), builder);
        }
        return builder.toString();
    }

    private static void appendFinding(FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo finding, StringBuilder builder) {
        builder.append(finding.getId());
        builder.append(SEPARATOR);
        builder.append(finding.getFindingIndexPartition());
        builder.append(SEPARATOR);
        builder.append(finding.getCategoryName());
        builder.append(SEPARATOR);
        builder.append(finding.getGroupName());
        builder.append(SEPARATOR);
        builder.append(finding.getBirthCommit());
        builder.append(SEPARATOR);
        builder.append(DebugDetailedFindingsListService.getBirthCause(finding));
        builder.append(SEPARATOR);
        builder.append(finding.getDeathCommit());
        builder.append(SEPARATOR);
        builder.append(DebugDetailedFindingsListService.getDeathCause(finding));
        builder.append(SEPARATOR);
        builder.append(finding.getLocationString());
        builder.append(SEPARATOR);
        builder.append(finding.getMessage());
        builder.append("\n");
    }

    private static String getBirthCause(FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo finding) {
        if (finding.isCreatedByOtherChange()) {
            return "change in other file";
        }
        if (finding.getCreationDiff() == null) {
            return "created with file";
        }
        return "change in affected file";
    }

    private static String getDeathCause(FindingsIntroductionRemovalServiceBase.TrackedFindingWithDiffInfo finding) {
        if (finding.isAlive()) {
            return "still alive";
        }
        if (finding.isRemovedByOtherChange()) {
            return "change in other file";
        }
        if (finding.getRemovalDiff() == null) {
            return "deleted with file";
        }
        return "change to affected file";
    }
}

