/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.critical_change;

import com.teamscale.commons.links.TeamscaleLinkProvider;
import com.teamscale.service.badge.CriticalChangeBadgeQueryParams;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/merge-requests/critical-changes")
public class MergeRequestCriticalChangeBadgePreviewService {
    @POST
    @Operation(summary="Creates a markdown link which renders the critical changes badge.", description="Creates a markdown link which renders the critical changes badge.", tags={"Merge Requests"})
    @RequiresNoPermission
    @Path(value="markdown-badge")
    public String previewCriticalChangeBadgeMarkdown(@RequestBody CriticalChangeBadgeQueryParams queryParams) throws StorageException {
        String badgeImageLink = new TeamscaleLinkProvider("/").createStaticCriticalChangeBadgeUrl(queryParams.getBadgeTitle(), queryParams.getBadgeText(), queryParams.getBadgeColor(), queryParams.getBadgeTooltip());
        String badgeTargetLink = StringUtils.isEmptyOrElse((String)queryParams.getBadgeLink(), (String)badgeImageLink);
        String altText = StringUtils.escapeChars((String)queryParams.getBadgeTooltip(), Map.of("[", "\\[", "]", "\\]"));
        return "[![%s](%s)](%s \"%s\")".formatted(altText, badgeImageLink, badgeTargetLink, queryParams.getBadgeTooltip());
    }
}

