/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.distribution;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics/file-distribution")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.class, SpecItemContributor.class})
public class MetricFileDistributionService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get metric file distribution", description="Retrieves the metric file distribution for the provided metric and regexps.", responses={@ApiResponse(responseCode="400", description="Invalid regular expressions provided.")}, tags={"Metrics"})
    public List<Double> getMetricFileDistribution(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to compute metric file distribution for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Metric name to compute file distribution for", required=true) @QueryParam(value="metric-name") String metricName, @Parameter(description="Regular expressions identifying the file to compute the metric distribution for") @QueryParam(value="file-regexps") List<Pattern> fileRegexps) throws StorageException {
        int metricPosition = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem())).getMetricDirectorySchema().getValuePosition(metricName);
        PairList<String, Double> metricValues = this.getMetricValues(uniformPath, this.determineHistoryOption(commit), metricPosition, metricName);
        return MetricFileDistributionService.aggregateMetricValues(metricValues, fileRegexps);
    }

    private PairList<String, Double> getMetricValues(UniformPath uniformPath, HistoryAccessOption historyAccessOption, int metricPosition, String metricName) throws StorageException {
        ArrayList allSourcePaths = new ArrayList(ArchitectureMetricsUtils.getArchitectureFreeSourcePaths((String)uniformPath.toString(), (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption));
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        List entries = metricRetrievalStrategy.getMetricDirectoryEntries(allSourcePaths, historyAccessOption);
        PairList metricValues = new PairList();
        for (MetricDirectoryEntry entry : entries) {
            if (entry.hasChildren() || entry.isEntryForArchitectureFile()) continue;
            if (entry.getValueWithoutNullAssert(metricPosition) == null) {
                LOGGER.error("Encountered incomplete entry for metric '%s' (position %s): %s".formatted(metricName, metricPosition, entry));
                continue;
            }
            String entryPath = entry.getUniformPath();
            metricValues.add((Object)entryPath, (Object)((Double)entry.getValue(metricPosition)));
        }
        return metricValues;
    }

    private static List<Double> aggregateMetricValues(PairList<String, Double> metricValues, List<Pattern> patterns) {
        Object[] aggregatedValues = new Double[patterns.size()];
        Arrays.fill(aggregatedValues, (Object)0.0);
        block0: for (int i = 0; i < metricValues.size(); ++i) {
            String uniformPath = (String)metricValues.getFirst(i);
            for (int j = 0; j < patterns.size(); ++j) {
                Matcher matcher = patterns.get(j).matcher(uniformPath);
                if (!matcher.find()) continue;
                Object[] objectArray = aggregatedValues;
                int n = j;
                Double.valueOf((Double)objectArray[n] + (Double)metricValues.getSecond(i));
                continue block0;
            }
        }
        return Arrays.asList(aggregatedValues);
    }
}

