/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.teamscale.index.resource.utils.EResourceType;
import java.util.Objects;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SinglePathDescriptor {
    private final String rootPath;
    private final String relativePath;
    private final EResourceType resourceType;
    private boolean isContentExcluded;

    public SinglePathDescriptor(String rootPath, String relativePath, EResourceType resourceType) {
        this.rootPath = rootPath;
        this.relativePath = relativePath;
        this.resourceType = resourceType;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public EResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean isContentExcluded() {
        return this.isContentExcluded;
    }

    public void setIsContentExcluded(boolean isContentExcluded) {
        this.isContentExcluded = isContentExcluded;
    }

    public String getUniformPath() {
        if (StringUtils.isEmpty((String)this.relativePath)) {
            return this.rootPath;
        }
        if (StringUtils.isEmpty((String)this.rootPath)) {
            return this.relativePath;
        }
        return this.rootPath + UniformPathUtils.SEPARATOR + this.relativePath;
    }

    public String toString() {
        String root;
        String prefix = "";
        if (this.isContentExcluded) {
            prefix = "[Excluded] ";
        }
        if (StringUtils.isEmpty((String)(root = this.rootPath))) {
            root = ".";
        }
        return prefix + root + " + " + this.relativePath + " (" + String.valueOf(this.resourceType) + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SinglePathDescriptor) {
            return this.isContentExcluded() == ((SinglePathDescriptor)obj).isContentExcluded() && this.getRootPath().contentEquals(((SinglePathDescriptor)obj).getRootPath()) && this.getRelativePath().contentEquals(((SinglePathDescriptor)obj).getRelativePath()) && this.getResourceType() == ((SinglePathDescriptor)obj).getResourceType();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.rootPath, this.relativePath, this.resourceType, this.isContentExcluded);
    }
}

