/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.monitoring.prometheus.PrometheusMetricsExportUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.monitoring.prometheus.collectors.ArtifactStoreSizeMetricCollector;
import com.teamscale.service.monitoring.prometheus.collectors.CommitterMetricsCollector;
import com.teamscale.service.monitoring.prometheus.collectors.CriticalSystemStateCollector;
import com.teamscale.service.monitoring.prometheus.collectors.GlobalStorageMetricCollector;
import com.teamscale.service.monitoring.prometheus.collectors.HealthMetricsCollector;
import com.teamscale.service.monitoring.prometheus.collectors.LicenseMetricsCollector;
import com.teamscale.service.monitoring.prometheus.collectors.ProjectMetricsCollector;
import com.teamscale.service.monitoring.prometheus.collectors.SchedulerMetricsCollector;
import com.teamscale.service.monitoring.prometheus.collectors.UserMetricsCollector;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.ExpositionFormats;
import io.prometheus.metrics.instrumentation.jvm.JvmMetrics;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/monitoring/prometheus")
public class PrometheusMetricService
extends ApiBase {
    private static boolean initialized = false;

    @GET
    @Produces(value={"text/plain; version=0.0.4; charset=utf-8", "application/openmetrics-text; version=1.0.0; charset=utf-8", "application/vnd.google.protobuf; proto=io.prometheus.client.MetricFamily; encoding=delimited"})
    @RequiresGlobalPermission(value={EGlobalPermission.MONITORING_SERVICES})
    @Operation(summary="Get prometheus metrics", description="Returns metrics in prometheus format", tags={"Monitoring"})
    public String getMetrics(@HeaderParam(value="Accept") @Nullable String acceptHeader) throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        ExpositionFormatWriter writer = ExpositionFormats.init().findWriter(acceptHeader);
        return PrometheusMetricsExportUtils.writePrometheusMetrics((ExpositionFormatWriter)writer, (String)this.serviceInfo.getServerConfiguration().getInstanceName(), (ServerOptionIndex)serverOptionIndex);
    }

    public static void registerAll(IndexLayer indexLayer) {
        if (initialized) {
            return;
        }
        initialized = true;
        new HealthMetricsCollector(indexLayer);
        new ProjectMetricsCollector(indexLayer);
        new GlobalStorageMetricCollector(indexLayer);
        new CriticalSystemStateCollector(indexLayer);
        new LicenseMetricsCollector();
        new SchedulerMetricsCollector(indexLayer);
        new UserMetricsCollector(indexLayer);
        new CommitterMetricsCollector(indexLayer);
        new ArtifactStoreSizeMetricCollector(indexLayer);
        JvmMetrics.builder().register();
    }
}

