/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.service.monitoring.prometheus.PrometheusMetricsUtils;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class SchedulerMetricsCollector
extends IndexCallbackMetricsProviderBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public SchedulerMetricsCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("scheduler_state")).help("The state of the scheduler. " + PrometheusMetricsUtils.createCommentForEnumConversion(ProjectSchedulingFilter.ESchedulingMode.class))).callback(this::collectSchedulerState).register();
    }

    private void collectSchedulerState(GaugeWithCallback.Callback cb) {
        try {
            WorkerIndex workerIndex = (WorkerIndex)this.indexLayer.openGlobalIndex(WorkerIndex.class);
            ProjectSchedulingFilter projectSchedulingFilter = workerIndex.getSchedulingFilterAccess().get();
            ProjectSchedulingFilter.ESchedulingMode schedulingMode = projectSchedulingFilter.getSchedulingMode();
            cb.call((double)schedulingMode.ordinal(), new String[0]);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve job size.", (Throwable)e);
        }
    }
}

