/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.precommit.PreCommitLimitsOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.precommit.PreCommitServerLimits;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/pre-commit/server-limits")
public class PreCommitServerLimitService
extends ApiBase {
    @GET
    @RequiresNoPermission
    @Operation(summary="Get pre-commit server limits", description="Returns the configured limits for pre-commit analysis (file count, file size, etc.).", tags={"Pre-Commit"})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0)
    public PreCommitServerLimits getPreCommitServerLimits() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        PreCommitLimitsOption limits = (PreCommitLimitsOption)ServerOptionRegistry.getInstance().getServerOption("precommit.limit.options", PreCommitLimitsOption.class, serverOptionIndex);
        return new PreCommitServerLimits(limits.fileCount, FileSystemUtils.parseDataSize((String)limits.fileSize), limits.timeLimit);
    }
}

