/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.google.common.collect.Sets;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.service.precommit.RepositoryConnectorShallowConfig;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.PreCommit3Result;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class PreCommitUploadDataFilter {
    public static final String INTERNAL_SNIPPET_ANALYSIS_FILE_PREFIX = "snippet-analysis-file";
    private final List<RepositoryConnectorShallowConfig> connectorShallowConfigs;
    private final RepositoryOriginalPathIndex originalPathIndex;

    public PreCommitUploadDataFilter(List<RepositoryConnectorShallowConfig> connectorShallowConfigs, RepositoryOriginalPathIndex originalPathIndex) {
        this.connectorShallowConfigs = connectorShallowConfigs;
        this.originalPathIndex = originalPathIndex;
    }

    public Map<String, String> filterUploadData(Map<String, @Nullable String> uploadData, Set<ELanguage> acceptedLanguages, Consumer<PreCommit3Result.PreCommit3ErrorDetail> errorCallback) throws StorageException {
        List<RepositoryConnectorShallowConfig> relevantConnectors = this.connectorShallowConfigs.stream().filter(config -> !config.sourceLibraryConnector).filter(config -> !ERepositoryConnector.isIgnoredByPreCommit3((ERepositoryConnector)ERepositoryConnector.findByReadableName((String)config.getType()))).toList();
        if (relevantConnectors.isEmpty()) {
            errorCallback.accept(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.NO_VALID_CONNECTOR, (String)"The project has no connector which accepts pre-commits.", (boolean)true));
            return Collections.emptyMap();
        }
        HashSet<String> notYetRetainedUniformPaths = new HashSet<String>(uploadData.keySet());
        HashMap<String, String> retainedUploadData = new HashMap<String, String>(uploadData.size());
        HashMap<String, EExclusionReason> exclusionReasonForUniformPaths = new HashMap<String, EExclusionReason>(uploadData.size());
        for (RepositoryConnectorShallowConfig repositoryConnectorShallowConfig : relevantConnectors) {
            this.filterAgainstConnector(repositoryConnectorShallowConfig, uploadData, notYetRetainedUniformPaths, retainedUploadData, acceptedLanguages, exclusionReasonForUniformPaths);
            if (!exclusionReasonForUniformPaths.isEmpty()) continue;
            break;
        }
        for (Map.Entry entry : exclusionReasonForUniformPaths.entrySet()) {
            String uniformPath = (String)entry.getKey();
            EExclusionReason reason = (EExclusionReason)((Object)entry.getValue());
            errorCallback.accept(PreCommit3Result.PreCommit3ErrorDetail.createErrorForFile((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.FILE_EXCLUDED_BY_PROJECT_CONFIGURATION, (String)reason.getMessage(uniformPath), (String)uniformPath, (boolean)true));
        }
        return retainedUploadData;
    }

    private void filterAgainstConnector(RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, @Nullable String> uploadData, Set<String> notYetRetainedUniformPaths, HashMap<String, String> retainedUploadData, Set<ELanguage> acceptedLanguages, HashMap<String, EExclusionReason> exclusionReasonForUniformPaths) throws StorageException {
        Map originalPathMap = this.originalPathIndex.getRepositoryPaths(connectorShallowConfig.getRepositoryIdentifier(), new ArrayList<String>(uploadData.keySet()));
        for (String uniformPath : notYetRetainedUniformPaths) {
            String fileContent;
            EExclusionReason exclusionReason = PreCommitUploadDataFilter.determineWhetherConnectorWouldIncludeFile(uniformPath, fileContent = uploadData.get(uniformPath), connectorShallowConfig, originalPathMap, acceptedLanguages);
            if (exclusionReason == EExclusionReason.NONE) {
                retainedUploadData.put(uniformPath, fileContent);
                exclusionReasonForUniformPaths.remove(uniformPath);
                continue;
            }
            exclusionReasonForUniformPaths.putIfAbsent(uniformPath, exclusionReason);
            if (exclusionReasonForUniformPaths.get(uniformPath).compareTo(exclusionReason) <= 0) continue;
            exclusionReasonForUniformPaths.put(uniformPath, exclusionReason);
        }
        notYetRetainedUniformPaths.removeAll(retainedUploadData.keySet());
    }

    private static EExclusionReason determineWhetherConnectorWouldIncludeFile(String uniformPath, @Nullable String fileContent, RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, String> originalPathMap, Set<ELanguage> acceptedLanguages) {
        if (uniformPath.startsWith(INTERNAL_SNIPPET_ANALYSIS_FILE_PREFIX)) {
            if (!Sets.intersection(acceptedLanguages, (Set)ELanguage.getAllLanguagesForPath((String)uniformPath)).isEmpty()) {
                return EExclusionReason.NONE;
            }
            return EExclusionReason.INCLUDE_EXCLUDE_PATTERN;
        }
        if (!PreCommitUploadDataFilter.fileIsIncluded(uniformPath, connectorShallowConfig, originalPathMap)) {
            return EExclusionReason.INCLUDE_EXCLUDE_PATTERN;
        }
        if (fileContent != null && connectorShallowConfig.isContentExcluded(fileContent)) {
            return EExclusionReason.CONTENT_EXCLUDE;
        }
        return EExclusionReason.NONE;
    }

    private static boolean fileIsIncluded(String uniformPath, RepositoryConnectorShallowConfig connectorShallowConfig, Map<String, String> originalPathMap) {
        String uniformPathWithoutRepoIdentifier = StringUtils.stripPrefix((String)uniformPath, (String)connectorShallowConfig.getPrependedRepositoryIdentifier());
        if (connectorShallowConfig.fileIsIncluded(uniformPathWithoutRepoIdentifier)) {
            return true;
        }
        String repositoryPath = originalPathMap.get(uniformPath);
        if (repositoryPath != null && connectorShallowConfig.fileIsIncluded(repositoryPath)) {
            return true;
        }
        return connectorShallowConfig.fileIsIncludedWithTransformations(uniformPathWithoutRepoIdentifier);
    }

    @VisibleForTesting
    static enum EExclusionReason {
        NONE(null),
        CONTENT_EXCLUDE("%s is excluded by project content-exclude pattern."),
        INCLUDE_EXCLUDE_PATTERN("%s is excluded by project include/exclude-path pattern.");

        private final String message;

        private EExclusionReason(String message) {
            this.message = message;
        }

        @VisibleForTesting
        String getMessage(String uniformPath) {
            if (this.message == null) {
                return null;
            }
            return String.format(this.message, uniformPath);
        }
    }
}

