/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.precommit.PreCommitUploadCommit;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/pre-commit/debug/staging-index")
public class DebugPreCommitUploadStagingIndexService
extends ApiBase {
    @GET
    @Operation(description="Dumps the currently staged pre-commit requests.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getIndexContents() throws StorageException {
        IBranchingLayer layer = this.openBranchingLayerInProject("pre-commit-staging", PreCommitUploadStagingIndex.class);
        ArrayList<String> formattedPreCommitInfos = new ArrayList<String>();
        for (IBranchCommitInfo indexEntry : layer.getCommitInfos()) {
            PreCommitUploadStagingIndex index = this.openProjectIndex(PreCommitUploadStagingIndex.class, HistoryAccessOption.readTimestamp((String)indexEntry.getBranchName(), (long)indexEntry.getTimestamp()));
            formattedPreCommitInfos.add(DebugPreCommitUploadStagingIndexService.format((PreCommitUploadCommit)index.getCommitInfo()));
        }
        return StringUtils.concat(formattedPreCommitInfos, (String)"\n\n");
    }

    private static String format(PreCommitUploadCommit commit) {
        return "commit: " + String.valueOf(commit.getCommit()) + "\n\tuser: " + commit.getUsername() + "\n\tparent: " + String.valueOf(commit.getParentCommit()) + "\n\tfiles new/changed/deleted: " + commit.getNewFiles().size() + "/" + commit.getChangedFiles().size() + "/" + commit.getDeletedFiles().size();
    }

    @DELETE
    @Operation(description="Deletes the currently staged pre-commit requests.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void deleteIndexContents() throws StorageException {
        IStore store = this.openStoreInProject("pre-commit-staging", PreCommitUploadStagingIndex.class);
        StorageUtils.clearStore((IStore)store);
    }
}

