/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.option.OptionServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/options")
public class ProjectOptionService
extends OptionServiceBase {
    @GET
    @Operation(summary="Get schema", description="Retrieves project option schema.", tags={"Project", "Administration"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="schema")
    public List<OptionDescriptor> getProjectOptionSchema() {
        return ProjectOptionRegistry.getInstance().getOptionDescriptors();
    }

    @GET
    @Operation(summary="Get options", description="Retrieves all available project options.", tags={"Project", "Administration"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Map<String, IOption> getProjectOptions() throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        return ProjectOptionRegistry.getInstance().getOptions("<p>", (OptionIndexBase)projectOptionIndex);
    }

    @PUT
    @Operation(summary="Edit options", description="Edits multiple project options at once.", tags={"Project", "Administration"}, responses={@ApiResponse(responseCode="404", description="No descriptor for one or more options found."), @ApiResponse(responseCode="400", description="Could not parse one or more options.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_PROJECT_OPTION})
    public void editProjectOptions(@Parameter(description="If options should be saved despite failing validation") @QueryParam(value="save-if-validation-fails") boolean saveIfValidationFails, @RequestBody(description="Map of option IDs to option values as JSON", required=true) Map<String, Object> optionsBatch) throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        this.editOptions((OptionRegistryBase)ProjectOptionRegistry.getInstance(), optionsBatch, "<p>", saveIfValidationFails, (OptionIndexBase)projectOptionIndex);
    }

    @GET
    @Operation(summary="Get option", description="Retrieves the project option identified by the given name.", responses={@ApiResponse(responseCode="404", description="Unknown option name provided")}, tags={"Project", "Administration"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{optionId}")
    public IOption getSingleProjectOption(@Parameter(description="Name of the option to retrieve.") @PathParam(value="optionId") String optionId) throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        return this.getSingleOption("<p>", optionId, (OptionIndexBase)projectOptionIndex, (OptionRegistryBase)ProjectOptionRegistry.getInstance());
    }

    @PUT
    @Operation(summary="Edit option", description="Edits the project option identified by the given name.", tags={"Project", "Administration"}, responses={@ApiResponse(responseCode="404", description="No descriptor for option found."), @ApiResponse(responseCode="400", description="Could not parse the given option.")})
    @Path(value="{optionId}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_PROJECT_OPTION})
    public void editProjectOption(@Parameter(description="Name of the option to edit") @PathParam(value="optionId") String optionId, @RequestBody(required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}) byte[] optionJson) throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        this.editOption((OptionRegistryBase)ProjectOptionRegistry.getInstance(), optionJson, "<p>", optionId, false, (OptionIndexBase)projectOptionIndex);
    }

    @DELETE
    @Operation(summary="Delete option", description="Delete the project option identified by the given name.", tags={"Project", "Administration"})
    @Path(value="{optionId}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_PROJECT_OPTION})
    public void deleteProjectOption(@Parameter(description="Name of the option to delete") @PathParam(value="optionId") String optionId) throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        this.deleteOption((OptionRegistryBase)ProjectOptionRegistry.getInstance(), "<p>", optionId, (OptionIndexBase)projectOptionIndex);
    }
}

