/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.teamscale.index.quality_report.QualityArtifactDescriptor;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.retrospective.Retrospective;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.reports.QualityReportValidator;
import com.teamscale.service.reports.QualityRetrospectiveValidator;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class QualityArtifactValidator<QUALIYARTIFACT extends QualityArtifactDescriptor> {
    protected final QUALIYARTIFACT qualityArtifact;
    protected final ITeamscaleServiceInfo serviceInfo;

    protected QualityArtifactValidator(QUALIYARTIFACT qualityArtifact, ITeamscaleServiceInfo serviceInfo) {
        this.qualityArtifact = qualityArtifact;
        this.serviceInfo = serviceInfo;
    }

    public static <T extends QualityArtifactDescriptor> QualityArtifactValidator<T> getValidator(T qualityArtifact, ITeamscaleServiceInfo serviceInfo) {
        if (qualityArtifact instanceof QualityReport) {
            QualityReport qualityReport = (QualityReport)qualityArtifact;
            return new QualityReportValidator(qualityReport, serviceInfo);
        }
        return new QualityRetrospectiveValidator((Retrospective)qualityArtifact, serviceInfo);
    }

    public void validateOrThrow() throws StorageException, BadRequestException {
        List<String> validationErrors = this.validateArtifact(project -> {
            try {
                return this.serviceInfo.getIndexLayer().openProjectStorageSystem((IProjectId)this.serviceInfo.getIndexLayer().resolveToPrimaryPublicProjectId(project));
            }
            catch (StorageException e) {
                return null;
            }
        });
        if (!validationErrors.isEmpty()) {
            throw new BadRequestException(String.join((CharSequence)", ", validationErrors));
        }
    }

    protected List<String> validateArtifact(Function<IProjectId, ProjectStorageSystem> storageSystemAccessor) throws StorageException {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.qualityArtifact.getMetaInfo().getName())) {
            errors.add("Name can not be empty");
        }
        QualityArtifactProfile qualityArtifactProfile = this.qualityArtifact.getQualityArtifactProfile();
        long startTimestamp = qualityArtifactProfile.getBaselineWithType().getTimestamp();
        if (qualityArtifactProfile.getDefaultProjectSetting() == null) {
            errors.add("No default project set");
        } else {
            for (PublicProjectId referencedProject : this.getReferencedProjects()) {
                errors.addAll(QualityArtifactValidator.validateReportProjectSetting(referencedProject, startTimestamp, storageSystemAccessor));
            }
        }
        if (startTimestamp >= qualityArtifactProfile.getEndWithType().getTimestamp()) {
            errors.add("End date has to be after the start date.");
        }
        return errors;
    }

    protected List<PublicProjectId> getReferencedProjects() {
        return List.of(this.qualityArtifact.getQualityArtifactProfile().getDefaultProjectSetting().getProjectId());
    }

    private static List<String> validateReportProjectSetting(PublicProjectId projectId, long startTimestamp, Function<IProjectId, ProjectStorageSystem> storageSystemAccessor) throws StorageException {
        ArrayList<String> errors = new ArrayList<String>();
        ProjectStorageSystem projectStorage = storageSystemAccessor.apply((IProjectId)projectId);
        if (projectStorage == null) {
            errors.add("Project with id " + String.valueOf(projectId) + " cannot be found or accessed");
            return errors;
        }
        RepositoryLogIndex repoLogIndex = (RepositoryLogIndex)projectStorage.openProjectIndex(RepositoryLogIndex.class, null);
        long timestampOfFirstCommit = repoLogIndex.getOldestTimestamp();
        if (timestampOfFirstCommit == Long.MAX_VALUE) {
            errors.add("Cannot create quality artifact for project " + String.valueOf(projectId) + " until first commit is analyzed.");
        } else if (startTimestamp < timestampOfFirstCommit) {
            errors.add("Start date cannot be before first commit to project " + String.valueOf(projectId) + " on " + DateTimeUtils.getUiFormattedDateString((long)timestampOfFirstCommit));
        }
        return errors;
    }
}

