/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.core.user.User;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.quality_report.slides.MetricBarChartSlide;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.metrics.table.MetricTableServiceUtils;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MetricBarChartSlideRenderer
extends SlideRendererBase<MetricBarChartSlide.MetricBarChartSlideParameters> {
    public MetricBarChartSlideRenderer(SlideRenderContext<MetricBarChartSlide.MetricBarChartSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public MetricBarChartSlide.MetricBarChartSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        ProjectInfo projectInfo = this.renderContext.resolveProject(((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getProjectBranchPath());
        IStorageInfo projectAwareStorageInfo = this.renderContext.getLocalStorageInfo(projectInfo);
        UniformPath uniformPath = ((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getProjectBranchPath().getPath();
        String branch = ReportUtils.determineBranch(projectAwareStorageInfo, ((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getProjectBranchPath());
        long baselineTimestamp = this.getReportProfile().getBaselineWithType().getTimestamp();
        long reportEndTimestamp = this.getReportProfile().getEndWithType().getTimestamp();
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)branch, (long)reportEndTimestamp);
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(projectAwareStorageInfo.getProjectStorageSystem());
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)projectAwareStorageInfo.getProjectStorageSystem(), (GlobalStorageSystem)projectAwareStorageInfo.getGlobalStorageSystem(), (User)this.renderContext.getUser(), (MetricSchemaRetrieverFactory)schemaRetrieverFactory);
        List<MetricDirectorySchemaEntry> relevantMetrics = MetricBarChartSlideRenderer.loadAndAssertMetricsByName(metricRetrievalStrategy.getMetricDirectorySchema(), ((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getMetricNames());
        MetricThresholdConfiguration thresholdConfiguration = MetricTableServiceUtils.loadThresholdConfiguration(this.getReportProfile().getThresholdProfileName(), projectAwareStorageInfo, schemaRetrieverFactory);
        List<MetricBarChartSlide.SingleMetricResult> metricResults = this.collectMetricResults(baselineTimestamp, reportEndTimestamp, uniformPath, metricRetrievalStrategy, relevantMetrics, thresholdConfiguration, historyAccess, projectAwareStorageInfo);
        return new MetricBarChartSlide.MetricBarChartSlideResult(metricResults, this.getSlideCommentRenderData(((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getProjectBranchPath(), ((MetricBarChartSlide.MetricBarChartSlideParameters)this.getParameters()).getComments()));
    }

    private @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    MetricBarChartSlide.SingleMetricResult> collectMetricResults(long baselineTimestamp, long reportEndTimestamp, UniformPath uniformPath, IMetricRetrievalStrategy metricRetrievalStrategy, List<MetricDirectorySchemaEntry> relevantMetrics, MetricThresholdConfiguration thresholdConfiguration, HistoryAccessOption historyAccess, IStorageInfo projectAwareStorageInfo) throws StorageException {
        MetricAssessmentComputation assessmentComputation = this.buildMetricAssessmentComputer(projectAwareStorageInfo, thresholdConfiguration);
        ArrayList<MetricBarChartSlide.SingleMetricResult> result = new ArrayList<MetricBarChartSlide.SingleMetricResult>();
        for (MetricDirectorySchemaEntry metric : relevantMetrics) {
            MetricValueBase<?> endValue = MetricBarChartSlideRenderer.loadMetricValue(reportEndTimestamp, historyAccess.getBranchName(), metricRetrievalStrategy, metric, uniformPath);
            MetricValueBase<?> baselineValue = MetricBarChartSlideRenderer.loadMetricValue(baselineTimestamp, historyAccess.getBranchName(), metricRetrievalStrategy, metric, uniformPath);
            MetricAssessment metricAssessment = MetricTableServiceUtils.getMetricAssessmentFromThresholdConfiguration(uniformPath.toString(), historyAccess, thresholdConfiguration, metric.getName(), assessmentComputation).orElse(null);
            if (metricAssessment == null) {
                MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema(historyAccess);
                MetricDirectoryEntry metricDirectoryEntry = metricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, historyAccess);
                metricAssessment = MetricTableServiceUtils.getDefaultMetricAssessment(uniformPath.toString(), schema, metric.getName(), metricDirectoryEntry);
            }
            result.add(new MetricBarChartSlide.SingleMetricResult(metric.getName(), baselineValue, endValue, metricAssessment));
        }
        return result;
    }

    private @NonNull MetricAssessmentComputation buildMetricAssessmentComputer(IStorageInfo storageInfo, MetricThresholdConfiguration thresholdConfiguration) throws StorageException {
        ProjectStorageSystem projectStorageSystem = storageInfo.getProjectStorageSystem();
        MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(projectStorageSystem);
        String thresholdConfigurationName = thresholdConfiguration.getName();
        MetricThresholdEvaluator thresholdConfigurationInterval = ProjectThresholdConfigurationUtils.getThresholdEvaluator((String)thresholdConfigurationName, (IStorageInfo)storageInfo, (MetricSchemaRetrieverFactory)schemaRetrieverFactory);
        MetricDataRetrieverFactory metricDataRetrieverFactory = new MetricDataRetrieverFactory(projectStorageSystem, storageInfo.getGlobalStorageSystem(), this.renderContext.getUser(), schemaRetrieverFactory);
        return new MetricAssessmentComputation(thresholdConfigurationInterval, metricDataRetrieverFactory, projectStorageSystem, IParallelTaskExecutor.sameThread());
    }

    private static List<MetricDirectorySchemaEntry> loadAndAssertMetricsByName(MetricDirectorySchema schema, List<String> metricNames) {
        List<MetricDirectorySchemaEntry> relevantMetrics = schema.getAllEntries().stream().filter(entry -> metricNames.contains(entry.getName())).collect(Collectors.toList());
        CCSMAssert.isTrue((metricNames.size() == relevantMetrics.size() ? 1 : 0) != 0, (String)ReportUtils.getMetricSchemaAssertionErrorMessage(schema, metricNames));
        return relevantMetrics;
    }

    private static @Nullable MetricValueBase<?> loadMetricValue(long timestamp, @NonNull String resolvedBranch, IMetricRetrievalStrategy retrievalStrategy, MetricDirectorySchemaEntry metricEntry, UniformPath uniformPath) throws StorageException {
        CCSMAssert.isNotEmpty((String)resolvedBranch, (String)"No branch given");
        CCSMAssert.isTrue((metricEntry.getValueType() == EMetricValueType.NUMERIC || metricEntry.getValueType() == EMetricValueType.ASSESSMENT ? 1 : 0) != 0, (String)"Only numeric or assessment metrics are supported.");
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)resolvedBranch, (long)timestamp);
        MetricDirectoryEntry entry = retrievalStrategy.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (entry == null) {
            return null;
        }
        MetricDirectorySchema schema = retrievalStrategy.getMetricDirectorySchema(historyAccessOption);
        int metricOffset = schema.getValuePosition(metricEntry.getName());
        return MetricValueBase.createWithRawValue((MetricDirectorySchemaEntry)metricEntry, (Object)entry.getValue(metricOffset));
    }
}

