/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.compare;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.diff.TokenBasedDiffer;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.LineBasedDiffer;
import org.conqat.lib.commons.diff.RegionDiffer;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/compare-elements")
public class ElementComparisonService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LOCAL_DISK_ACCESS_MARKER = "_local_";
    private static final Pattern FULL_PATH_PATTERN = Pattern.compile("^(.+?)/(.+?)(?:#@#(.+))?$");

    @Operation(summary="Get diffs for two files", description="Compares two elements with each other. The elements are given via a full path including project and uniform path and (optionally) the commit separated by '#@#'", tags={"Project", "Source Code"})
    @GET
    @RequiresNoPermission(description="Requires read permissions on the projects containing the files to be compared")
    public List<DiffDescription> getDiffs(@QueryParam(value="left") @Parameter(required=true, description="The full path of the left element of the comparison. Notation: {project}/{uniformPath}#@#{commit}") String leftPath, @QueryParam(value="right") @Parameter(required=true, description="The full path of the right element of the comparison. Notation: {project}/{uniformPath}#@#{commit}") String rightPath, @QueryParam(value="region") @Parameter(description="An optional explicit region to focus on. This can be used, e.g., to highlight differences in a clone. The format of this region is 'leftStart-leftEnd:rightStart-rightEnd', e.g. '45-67:22-43'.") String region) throws StorageException {
        TokenElementInfo leftElement = ElementComparisonService.fetchElement(leftPath, this.serviceInfo);
        TokenElementInfo rightElement = ElementComparisonService.fetchElement(rightPath, this.serviceInfo);
        boolean isCaseSensitive = leftElement.getLanguage().isCaseSensitive() || rightElement.getLanguage().isCaseSensitive();
        ArrayList<DiffDescription> diffs = new ArrayList<DiffDescription>();
        if (region != null) {
            diffs.add(new RegionDiffer(region).performDiff((Object)leftElement.getText(), (Object)rightElement.getText()));
        } else {
            diffs.add(new LineBasedDiffer(false).performDiff((Object)leftElement.getText(), (Object)rightElement.getText()));
            diffs.add(new LineBasedDiffer(true).performDiff((Object)leftElement.getText(), (Object)rightElement.getText()));
            try {
                diffs.add(new TokenBasedDiffer(isCaseSensitive).performDiff((Object)leftElement, (Object)rightElement));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("Error in TokenBasedDiffer: ", (Throwable)e);
            }
        }
        return diffs;
    }

    static TokenElementInfo fetchElement(String path, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        Matcher matcher = FULL_PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new BadRequestException("Could not parse path: " + path);
        }
        PublicProjectId projectId = new PublicProjectId(matcher.group(1));
        String uniformPath = matcher.group(2);
        if (LOCAL_DISK_ACCESS_MARKER.equals(projectId.toString())) {
            return ElementComparisonService.fetchLocalDiskElement(uniformPath, serviceInfo);
        }
        serviceInfo.getPermissions().checkReadInProject((IProjectId)projectId);
        CommitResolvingStorageSystem projectStorageSystem = serviceInfo.getIndexLayer().openProjectStorageSystem((IProjectId)projectId, StorageCacheConfiguration.FULL_CACHING);
        String extendedTimestamp = matcher.group(3);
        HistoryAccessOption historyAccessOption = ElementComparisonService.determineHistoryAccessOption(extendedTimestamp, (ProjectStorageSystem)projectStorageSystem);
        TokenElementIndex contentIndex = TokenElementIndex.open((ProjectStorageSystem)projectStorageSystem, (HistoryAccessOption)historyAccessOption);
        TokenElementInfo result = contentIndex.getTokenElement(uniformPath);
        if (result == null) {
            return TokenElementInfo.createWithLocalPreprocessing((String)uniformPath, (ELanguage)ELanguage.TEXT, (String)"");
        }
        return result;
    }

    private static TokenElementInfo fetchLocalDiskElement(String uniformPath, ITeamscaleServiceInfo serviceInfo) throws BadRequestException {
        ElementComparisonService.checkLocalFileAccessForAuditXClones(serviceInfo.getPermissions());
        try {
            String text = FileSystemUtils.readFileUTF8((File)new File(uniformPath));
            return TokenElementInfo.createWithLocalPreprocessing((String)uniformPath, (ELanguage)ELanguage.fromPath((String)uniformPath), (String)text);
        }
        catch (IOException e) {
            throw new BadRequestException("File not found: " + uniformPath + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static void checkLocalFileAccessForAuditXClones(ServicePermissions servicePermissions) {
        servicePermissions.checkAccessAdministrativeServices();
        if (!EFeatureToggle.AUDIT_FEATURES.isEnabled()) {
            throw new ForbiddenException("This feature needs an audit enabled license!");
        }
    }

    private static HistoryAccessOption determineHistoryAccessOption(String extendedTimestamp, ProjectStorageSystem projectStorageSystem) throws BadRequestException, StorageException {
        if (extendedTimestamp == null) {
            return HistoryAccessOption.readHead((String)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName());
        }
        try {
            CommitDescriptor commit = UnresolvedCommitDescriptorUtils.parseAndResolveCommit((String)extendedTimestamp, () -> projectStorageSystem);
            return HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Could not parse timestamp: " + extendedTimestamp);
        }
    }
}

